/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client;

import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.util.UnsafeUtil;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SodiumClientMod
implements ClientModInitializer {
    private static SodiumGameOptions CONFIG;
    private static Logger LOGGER;
    private static String MOD_VERSION;

    public void onInitializeClient() {
        ModContainer mod = (ModContainer)FabricLoader.getInstance().getModContainer("sodium").orElseThrow(NullPointerException::new);
        MOD_VERSION = mod.getMetadata().getVersion().getFriendlyString();
    }

    public static SodiumGameOptions options() {
        if (CONFIG == null) {
            CONFIG = SodiumClientMod.loadConfig();
        }
        return CONFIG;
    }

    public static Logger logger() {
        if (LOGGER == null) {
            LOGGER = LogManager.getLogger((String)"Sodium");
        }
        return LOGGER;
    }

    private static SodiumGameOptions loadConfig() {
        SodiumGameOptions config = SodiumGameOptions.load(FabricLoader.getInstance().getConfigDir().resolve("sodium-options.json"));
        SodiumClientMod.onConfigChanged(config);
        return config;
    }

    public static void onConfigChanged(SodiumGameOptions options) {
        UnsafeUtil.setEnabled(options.advanced.allowDirectMemoryAccess);
    }

    public static String getVersion() {
        if (MOD_VERSION == null) {
            throw new NullPointerException("Mod version hasn't been populated yet");
        }
        return MOD_VERSION;
    }
}

