/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.device;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import me.jellysquid.mods.sodium.client.gl.array.GlVertexArray;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBufferTarget;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBufferUsage;
import me.jellysquid.mods.sodium.client.gl.buffer.GlMutableBuffer;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.DrawCommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.state.GlStateTracker;
import me.jellysquid.mods.sodium.client.gl.tessellation.GlPrimitiveType;
import me.jellysquid.mods.sodium.client.gl.tessellation.GlTessellation;
import me.jellysquid.mods.sodium.client.gl.tessellation.GlVertexArrayTessellation;
import me.jellysquid.mods.sodium.client.gl.tessellation.TessellationBinding;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.opengl.GL32C;

public class GLRenderDevice
implements RenderDevice {
    private final GlStateTracker stateTracker = new GlStateTracker();
    private final CommandList commandList = new ImmediateCommandList(this.stateTracker);
    private final DrawCommandList drawCommandList = new ImmediateDrawCommandList();
    private boolean isActive;
    private GlTessellation activeTessellation;

    @Override
    public CommandList createCommandList() {
        this.checkDeviceActive();
        return this.commandList;
    }

    @Override
    public void makeActive() {
        if (this.isActive) {
            return;
        }
        this.stateTracker.clearRestoreState();
        this.isActive = true;
    }

    @Override
    public void makeInactive() {
        if (!this.isActive) {
            return;
        }
        this.stateTracker.applyRestoreState();
        this.isActive = false;
    }

    private void checkDeviceActive() {
        if (!this.isActive) {
            throw new IllegalStateException("Tried to access device from unmanaged context");
        }
    }

    private class ImmediateCommandList
    implements CommandList {
        private final GlStateTracker stateTracker;

        private ImmediateCommandList(GlStateTracker stateTracker) {
            this.stateTracker = stateTracker;
        }

        @Override
        public void bindVertexArray(GlVertexArray array) {
            if (this.stateTracker.makeVertexArrayActive(array)) {
                GL30C.glBindVertexArray((int)array.handle());
            }
        }

        @Override
        public void uploadData(GlMutableBuffer glBuffer, ByteBuffer byteBuffer) {
            this.bindBuffer(GlBufferTarget.ARRAY_BUFFER, glBuffer);
            GL20C.glBufferData((int)GlBufferTarget.ARRAY_BUFFER.getTargetParameter(), (ByteBuffer)byteBuffer, (int)glBuffer.getUsageHint().getId());
            glBuffer.setSize(byteBuffer.limit());
        }

        @Override
        public void copyBufferSubData(GlBuffer src, GlMutableBuffer dst, long readOffset, long writeOffset, long bytes) {
            if (writeOffset + bytes > dst.getSize()) {
                throw new IllegalArgumentException("Not enough space in destination buffer (writeOffset + bytes > bufferSize)");
            }
            this.bindBuffer(GlBufferTarget.COPY_READ_BUFFER, src);
            this.bindBuffer(GlBufferTarget.COPY_WRITE_BUFFER, dst);
            GL31C.glCopyBufferSubData((int)36662, (int)36663, (long)readOffset, (long)writeOffset, (long)bytes);
        }

        @Override
        public void bindBuffer(GlBufferTarget target, GlBuffer buffer) {
            if (this.stateTracker.makeBufferActive(target, buffer)) {
                GL20C.glBindBuffer((int)target.getTargetParameter(), (int)buffer.handle());
            }
        }

        @Override
        public void unbindVertexArray() {
            if (this.stateTracker.makeVertexArrayActive(null)) {
                GL30C.glBindVertexArray((int)0);
            }
        }

        @Override
        public void invalidateBuffer(GlMutableBuffer glBuffer) {
            this.allocateBuffer(GlBufferTarget.ARRAY_BUFFER, glBuffer, 0L);
        }

        @Override
        public void allocateBuffer(GlBufferTarget target, GlMutableBuffer buffer, long bufferSize) {
            this.bindBuffer(target, buffer);
            GL20C.glBufferData((int)target.getTargetParameter(), (long)bufferSize, (int)buffer.getUsageHint().getId());
            buffer.setSize(bufferSize);
        }

        @Override
        public void deleteBuffer(GlBuffer buffer) {
            int handle = buffer.handle();
            buffer.invalidateHandle();
            GL20C.glDeleteBuffers((int)handle);
        }

        @Override
        public void deleteVertexArray(GlVertexArray array) {
            int handle = array.handle();
            array.invalidateHandle();
            GL30C.glDeleteVertexArrays((int)handle);
        }

        @Override
        public void flush() {
        }

        @Override
        public DrawCommandList beginTessellating(GlTessellation tessellation) {
            GLRenderDevice.this.activeTessellation = tessellation;
            GLRenderDevice.this.activeTessellation.bind(GLRenderDevice.this.commandList);
            return GLRenderDevice.this.drawCommandList;
        }

        @Override
        public void deleteTessellation(GlTessellation tessellation) {
            tessellation.delete(this);
        }

        @Override
        public GlMutableBuffer createMutableBuffer(GlBufferUsage usage) {
            return new GlMutableBuffer(GLRenderDevice.this, usage);
        }

        @Override
        public GlTessellation createTessellation(GlPrimitiveType primitiveType, TessellationBinding[] bindings, GlBuffer indexBuffer) {
            GlVertexArrayTessellation tessellation = new GlVertexArrayTessellation(new GlVertexArray(GLRenderDevice.this), primitiveType, bindings, indexBuffer);
            tessellation.init(this);
            return tessellation;
        }
    }

    private class ImmediateDrawCommandList
    implements DrawCommandList {
        @Override
        public void multiDrawElementsBaseVertex(PointerBuffer pointer, IntBuffer count, IntBuffer baseVertex) {
            GlPrimitiveType primitiveType = GLRenderDevice.this.activeTessellation.getPrimitiveType();
            GL32C.glMultiDrawElementsBaseVertex((int)primitiveType.getId(), (IntBuffer)count, (int)5125, (PointerBuffer)pointer, (IntBuffer)baseVertex);
        }

        @Override
        public void multiDrawElements(PointerBuffer pointer, IntBuffer count) {
            GlPrimitiveType primitiveType = GLRenderDevice.this.activeTessellation.getPrimitiveType();
            GL32C.glMultiDrawElements((int)primitiveType.getId(), (IntBuffer)count, (int)5125, (PointerBuffer)pointer);
        }

        @Override
        public void endTessellating() {
            GLRenderDevice.this.activeTessellation.unbind(GLRenderDevice.this.commandList);
            GLRenderDevice.this.activeTessellation = null;
        }

        @Override
        public void flush() {
            if (GLRenderDevice.this.activeTessellation != null) {
                this.endTessellating();
            }
        }
    }
}

