/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.shader;

import me.jellysquid.mods.sodium.client.gl.GlObject;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderType;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderWorkarounds;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL20C;

public class GlShader
extends GlObject {
    private static final Logger LOGGER = LogManager.getLogger(GlShader.class);
    private final class_2960 name;

    public GlShader(RenderDevice owner, ShaderType type, class_2960 name, String src) {
        super(owner);
        int result;
        this.name = name;
        int handle = GL20C.glCreateShader((int)type.id);
        ShaderWorkarounds.safeShaderSource(handle, src);
        GL20C.glCompileShader((int)handle);
        String log = GL20C.glGetShaderInfoLog((int)handle);
        if (!log.isEmpty()) {
            LOGGER.warn("Shader compilation log for " + this.name + ": " + log);
        }
        if ((result = GL20C.glGetShaderi((int)handle, (int)35713)) != 1) {
            throw new RuntimeException("Shader compilation failed, see log for details");
        }
        this.setHandle(handle);
    }

    public class_2960 getName() {
        return this.name;
    }

    public void delete() {
        GL20C.glDeleteShader((int)this.handle());
        this.invalidateHandle();
    }
}

