/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.util;

import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.IntBuffer;
import me.jellysquid.mods.sodium.client.util.UnsafeUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import sun.misc.Unsafe;

public interface GlMultiDrawBatch {
    public static GlMultiDrawBatch create(int capacity) {
        return UnsafeUtil.isAvailable() ? new UnsafeMultiDrawBatch(capacity) : new NioMultiDrawBatch(capacity);
    }

    public PointerBuffer getPointerBuffer();

    public IntBuffer getCountBuffer();

    public IntBuffer getBaseVertexBuffer();

    public void begin();

    public void add(int var1, int var2, int var3);

    public void end();

    public void delete();

    public boolean isEmpty();

    public static class UnsafeMultiDrawBatch
    implements GlMultiDrawBatch {
        private static final Unsafe UNSAFE = UnsafeUtil.instanceNullable();
        private final PointerBuffer bufPointer;
        private final IntBuffer bufCount;
        private final IntBuffer bufBaseVertex;
        private long bufPointerAddr;
        private long bufCountAddr;
        private long bufBaseVertexAddr;
        private final int capacity;
        private int count;

        private UnsafeMultiDrawBatch(int capacity) {
            this.bufPointer = MemoryUtil.memAllocPointer((int)capacity);
            this.bufCount = MemoryUtil.memAllocInt((int)capacity);
            this.bufBaseVertex = MemoryUtil.memAllocInt((int)capacity);
            this.capacity = capacity;
            this.resetPointers();
        }

        private void resetPointers() {
            this.bufPointerAddr = MemoryUtil.memAddress((CustomBuffer)this.bufPointer);
            this.bufCountAddr = MemoryUtil.memAddress((IntBuffer)this.bufCount);
            this.bufBaseVertexAddr = MemoryUtil.memAddress((IntBuffer)this.bufBaseVertex);
        }

        @Override
        public PointerBuffer getPointerBuffer() {
            return MemoryUtil.memPointerBuffer((long)MemoryUtil.memAddress((CustomBuffer)this.bufPointer), (int)this.count);
        }

        @Override
        public IntBuffer getCountBuffer() {
            return MemoryUtil.memIntBuffer((long)MemoryUtil.memAddress((IntBuffer)this.bufCount), (int)this.count);
        }

        @Override
        public IntBuffer getBaseVertexBuffer() {
            return MemoryUtil.memIntBuffer((long)MemoryUtil.memAddress((IntBuffer)this.bufBaseVertex), (int)this.count);
        }

        @Override
        public void begin() {
            this.count = 0;
            this.resetPointers();
        }

        @Override
        public void add(int pointer, int count, int baseVertex) {
            if (this.count >= this.capacity) {
                throw new BufferUnderflowException();
            }
            UNSAFE.putLong(this.bufPointerAddr, pointer);
            this.bufPointerAddr += (long)Pointer.POINTER_SIZE;
            UNSAFE.putInt(this.bufCountAddr, count);
            this.bufCountAddr += 4L;
            UNSAFE.putInt(this.bufBaseVertexAddr, baseVertex);
            this.bufBaseVertexAddr += 4L;
            ++this.count;
        }

        @Override
        public void end() {
        }

        @Override
        public void delete() {
            MemoryUtil.memFree((PointerBuffer)this.bufPointer);
            MemoryUtil.memFree((Buffer)this.bufCount);
            MemoryUtil.memFree((Buffer)this.bufBaseVertex);
        }

        @Override
        public boolean isEmpty() {
            return this.count <= 0;
        }
    }

    public static class NioMultiDrawBatch
    implements GlMultiDrawBatch {
        private final PointerBuffer bufPointer;
        private final IntBuffer bufCount;
        private final IntBuffer bufBaseVertex;
        private int count;

        private NioMultiDrawBatch(int capacity) {
            this.bufPointer = MemoryUtil.memAllocPointer((int)capacity);
            this.bufCount = MemoryUtil.memAllocInt((int)capacity);
            this.bufBaseVertex = MemoryUtil.memAllocInt((int)capacity);
        }

        @Override
        public PointerBuffer getPointerBuffer() {
            return this.bufPointer;
        }

        @Override
        public IntBuffer getCountBuffer() {
            return this.bufCount;
        }

        @Override
        public IntBuffer getBaseVertexBuffer() {
            return this.bufBaseVertex;
        }

        @Override
        public void begin() {
            this.bufPointer.clear();
            this.bufCount.clear();
            this.bufBaseVertex.clear();
            this.count = 0;
        }

        @Override
        public void add(int pointer, int count, int baseVertex) {
            int i = this.count++;
            this.bufPointer.put(i, (long)pointer);
            this.bufCount.put(i, count);
            this.bufBaseVertex.put(i, baseVertex);
        }

        @Override
        public void end() {
            this.bufPointer.limit(this.count);
            this.bufCount.limit(this.count);
            this.bufBaseVertex.limit(this.count);
        }

        @Override
        public void delete() {
            MemoryUtil.memFree((PointerBuffer)this.bufPointer);
            MemoryUtil.memFree((Buffer)this.bufCount);
            MemoryUtil.memFree((Buffer)this.bufBaseVertex);
        }

        @Override
        public boolean isEmpty() {
            return this.count <= 0;
        }
    }
}

