/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.binding.compat.VanillaBooleanOptionBinding;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import me.jellysquid.mods.sodium.client.util.UnsafeUtil;
import net.minecraft.class_1041;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_316;
import net.minecraft.class_4060;
import net.minecraft.class_4061;
import net.minecraft.class_4064;
import net.minecraft.class_4066;
import net.minecraft.class_5365;

public class SodiumGameOptionPages {
    private static final SodiumOptionsStorage sodiumOpts = new SodiumOptionsStorage();
    private static final MinecraftOptionsStorage vanillaOpts = new MinecraftOptionsStorage();

    public static OptionPage general() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName("View Distance").setTooltip("The view distance controls how far away terrain will be rendered. Lower distances mean that less terrain will be rendered, improving frame rates.").setControl(option -> new SliderControl((Option<Integer>)option, 2, 32, 1, ControlValueFormatter.quantity("Chunks"))).setBinding((options, value) -> {
            options.field_1870 = value;
        }, options -> options.field_1870).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName("Brightness").setTooltip("Controls the brightness (gamma) of the game.").setControl(opt -> new SliderControl((Option<Integer>)opt, 0, 100, 1, ControlValueFormatter.brightness())).setBinding((opts, value) -> {
            opts.field_1840 = (double)value.intValue() * 0.01;
        }, opts -> (int)(opts.field_1840 / 0.01)).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName("Clouds").setTooltip("Controls whether or not clouds will be visible.").setControl(TickBoxControl::new).setBinding((opts, value) -> {
            class_276 framebuffer;
            opts.quality.enableClouds = value;
            if (class_310.method_29611() && (framebuffer = class_310.method_1551().field_1769.method_29364()) != null) {
                framebuffer.method_1230(class_310.field_1703);
            }
        }, opts -> opts.quality.enableClouds).setImpact(OptionImpact.LOW).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName("GUI Scale").setTooltip("Sets the maximum scale factor to be used for the user interface. If 'auto' is used, then the largest scale factor will always be used.").setControl(option -> new SliderControl((Option<Integer>)option, 0, 4, 1, ControlValueFormatter.guiScale())).setBinding((opts, value) -> {
            opts.field_1868 = value;
            class_310 client = class_310.method_1551();
            client.method_15993();
        }, opts -> opts.field_1868).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName("Fullscreen").setTooltip("If enabled, the game will display in full-screen (if supported).").setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_1857 = value;
            class_310 client = class_310.method_1551();
            class_1041 window = client.method_22683();
            if (window != null && window.method_4498() != opts.field_1857) {
                window.method_4500();
                opts.field_1857 = window.method_4498();
            }
        }, opts -> opts.field_1857).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName("V-Sync").setTooltip("If enabled, the game's frame rate will be synchronized to the monitor's refresh rate, making for a generally smoother experience at the expense of overall input latency. This setting might reduce performance if your system is too slow.").setControl(TickBoxControl::new).setBinding(new VanillaBooleanOptionBinding((class_4064<Boolean>)class_316.field_1927)).setImpact(OptionImpact.VARIES).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName("FPS Limit").setTooltip("Limits the maximum number of frames per second. In effect, this will throttle the game and can be useful when you want to conserve battery life or multi-task between other applications. If V-Sync is enabled, this option will be ignored unless it is lower than your display's refresh rate.").setControl(option -> new SliderControl((Option<Integer>)option, 5, 260, 5, ControlValueFormatter.fpsLimit())).setBinding((opts, value) -> {
            opts.field_1909 = value;
            class_310.method_1551().method_22683().method_15999(value.intValue());
        }, opts -> opts.field_1909).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName("View Bobbing").setTooltip("If enabled, the player's view will sway and bob when moving around. Players who suffer from motion sickness can benefit from disabling this.").setControl(TickBoxControl::new).setBinding(new VanillaBooleanOptionBinding((class_4064<Boolean>)class_316.field_1934)).build()).add(OptionImpl.createBuilder(class_4061.class, vanillaOpts).setName("Attack Indicator").setTooltip("Controls where the Attack Indicator is displayed on screen.").setControl(opts -> new CyclingControl<class_4061>((Option<class_4061>)opts, class_4061.class, new String[]{"Off", "Crosshair", "Hotbar"})).setBinding((opts, value) -> {
            opts.field_1895 = value;
        }, opts -> opts.field_1895).build()).build());
        return new OptionPage("General", (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage quality() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(class_5365.class, vanillaOpts).setName("Graphics Quality").setTooltip("The default graphics quality controls some legacy options and is necessary for mod compatibility. If the options below are left to \"Default\", they will use this setting.").setControl(option -> new CyclingControl<class_5365>((Option<class_5365>)option, class_5365.class, new String[]{"Fast", "Fancy", "Fabulous"})).setBinding((opts, value) -> {
            opts.field_25444 = value;
        }, opts -> opts.field_25444).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName("Clouds Quality").setTooltip("Controls the quality of rendered clouds in the sky.").setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.cloudQuality = value;
        }, opts -> opts.quality.cloudQuality).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName("Weather Quality").setTooltip("Controls the quality of rain and snow effects.").setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.weatherQuality = value;
        }, opts -> opts.quality.weatherQuality).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(class_4066.class, vanillaOpts).setName("Particle Quality").setTooltip("Controls the maximum number of particles which can be present on screen at any one time.").setControl(opt -> new CyclingControl<class_4066>((Option<class_4066>)opt, class_4066.class, new String[]{"High", "Medium", "Low"})).setBinding((opts, value) -> {
            opts.field_1882 = value;
        }, opts -> opts.field_1882).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName("Smooth Lighting").setTooltip("Controls whether blocks will be smoothly lit and shaded. This slightly increases the amount of time needed to re-build a chunk, but doesn't affect frame rates.").setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_1841 = value != false ? class_4060.field_18146 : class_4060.field_18144;
        }, opts -> opts.field_1841 == class_4060.field_18146).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName("Biome Blend").setTooltip("Controls the range which biomes will be sampled for block colorization. Higher values greatly increase the amount of time it takes to build chunks for diminishing improvements in quality.").setControl(option -> new SliderControl((Option<Integer>)option, 0, 7, 1, ControlValueFormatter.quantityOrDisabled("block(s)", "None"))).setBinding((opts, value) -> {
            opts.field_1878 = value;
        }, opts -> opts.field_1878).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName("Entity Distance").setTooltip("Controls how far away entities can render from the player. Higher values increase the render distance at the expense of frame rates.").setControl(option -> new SliderControl((Option<Integer>)option, 50, 500, 25, ControlValueFormatter.percentage())).setBinding((opts, value) -> {
            opts.field_24214 = (float)value.intValue() / 100.0f;
        }, opts -> Math.round(opts.field_24214 * 100.0f)).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName("Entity Shadows").setTooltip("If enabled, basic shadows will be rendered beneath mobs and other entities.").setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.field_1888 = value;
        }, opts -> opts.field_1888).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName("Vignette").setTooltip("If enabled, a vignette effect will be rendered on the player's view. This is very unlikely to make a difference to frame rates unless you are fill-rate limited.").setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.quality.enableVignette = value;
        }, opts -> opts.quality.enableVignette).setImpact(OptionImpact.LOW).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName("Mipmap Levels").setTooltip("Controls the number of mipmaps which will be used for block model textures. Higher values provide better rendering of blocks in the distance, but may adversely affect performance with many animated textures.").setControl(option -> new SliderControl((Option<Integer>)option, 0, 4, 1, ControlValueFormatter.multiplier())).setBinding((opts, value) -> {
            opts.field_1856 = value;
        }, opts -> opts.field_1856).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_ASSET_RELOAD).build()).build());
        return new OptionPage("Quality", (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage advanced() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName("Use Block Face Culling").setTooltip("If enabled, only the sides of blocks which are facing the camera will be submitted for rendering. This can eliminate a large number of block faces very early in the rendering process, saving memory bandwidth and time on the GPU. Some resource packs may have issues with this option, so try disabling it if you're seeing holes in blocks.").setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.useBlockFaceCulling = value;
        }, opts -> opts.advanced.useBlockFaceCulling).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName("Use Fog Occlusion").setTooltip("If enabled, chunks which are determined to be fully hidden by fog effects will not be rendered, helping to improve performance. The improvement can be more dramatic when fog effects are heavier (such as while underwater), but it may cause undesirable visual artifacts between the sky and fog in some scenarios.").setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.advanced.useFogOcclusion = value;
        }, opts -> opts.advanced.useFogOcclusion).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName("Use Entity Culling").setTooltip("If enabled, entities determined not to be in any visible chunks will be skipped during rendering. This can help improve performance by avoiding the rendering of entities located underground or behind walls.").setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.useEntityCulling = value;
        }, opts -> opts.advanced.useEntityCulling).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName("Use Particle Culling").setTooltip("If enabled, only particles which are determined to be visible will be rendered. This can provide a significant improvement to frame rates when many particles are nearby.").setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.advanced.useParticleCulling = value;
        }, opts -> opts.advanced.useParticleCulling).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName("Animate Only Visible Textures").setTooltip("If enabled, only animated textures determined to be visible will be updated. This can provide a significant boost to frame rates on some hardware, especially with heavier resource packs. If you experience issues with some textures not being animated, try disabling this option.").setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.advanced.animateOnlyVisibleTextures = value;
        }, opts -> opts.advanced.animateOnlyVisibleTextures).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName("Allow Direct Memory Access").setTooltip("If enabled, some critical code paths will be allowed to use direct memory access for performance. This often greatly reduces CPU overhead for chunk and entity rendering, but can make it harder to diagnose some bugs and crashes. You should only disable this if you've been asked to or otherwise know what you're doing.").setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).setEnabled(UnsafeUtil.isSupported()).setBinding((opts, value) -> {
            opts.advanced.allowDirectMemoryAccess = value;
        }, opts -> opts.advanced.allowDirectMemoryAccess).build()).build());
        return new OptionPage("Advanced", (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }
}

