/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.vertex.buffer;

import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.gl.attribute.BufferVertexFormat;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import net.minecraft.class_311;

public class VertexBufferBuilder
implements VertexBufferView {
    private final BufferVertexFormat vertexFormat;
    private ByteBuffer buffer;
    private int writerOffset;
    private int count;
    private int capacity;

    public VertexBufferBuilder(BufferVertexFormat vertexFormat, int initialCapacity) {
        this.vertexFormat = vertexFormat;
        this.buffer = class_311.method_1596((int)initialCapacity);
        this.capacity = initialCapacity;
        this.writerOffset = 0;
    }

    private void grow(int len) {
        int cap = Math.max(this.capacity * 2, this.capacity + len);
        ByteBuffer buffer = class_311.method_1596((int)cap);
        buffer.put(this.buffer);
        buffer.position(0);
        this.buffer = buffer;
        this.capacity = cap;
    }

    @Override
    public boolean ensureBufferCapacity(int bytes) {
        if (this.writerOffset + bytes <= this.capacity) {
            return false;
        }
        this.grow(bytes);
        return true;
    }

    @Override
    public ByteBuffer getDirectBuffer() {
        return this.buffer;
    }

    @Override
    public int getWriterPosition() {
        return this.writerOffset;
    }

    @Override
    public void flush(int vertexCount, BufferVertexFormat format) {
        if (this.vertexFormat != format) {
            throw new IllegalStateException("Mis-matched vertex format (expected: [" + format + "], currently using: [" + this.vertexFormat + "])");
        }
        this.count += vertexCount;
        this.writerOffset = this.count * format.getStride();
    }

    @Override
    public BufferVertexFormat getVertexFormat() {
        return this.vertexFormat;
    }

    public boolean isEmpty() {
        return this.count <= 0;
    }

    public int getByteSize() {
        return this.writerOffset;
    }

    public int getCount() {
        return this.count;
    }

    public void get(ByteBuffer dst) {
        this.buffer.clear();
        this.buffer.limit(this.writerOffset);
        dst.put(this.buffer);
        this.buffer.clear();
    }

    public void reset() {
        this.writerOffset = 0;
        this.count = 0;
    }
}

