/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkAdjacencyMap;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkCameraContext;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.graph.ChunkGraphInfo;
import me.jellysquid.mods.sodium.client.render.chunk.graph.ChunkGraphIterationQueue;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPassManager;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegionManager;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegionVisibility;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderEmptyBuildTask;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderRebuildTask;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListener;
import me.jellysquid.mods.sodium.client.world.ClientChunkManagerExtended;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import me.jellysquid.mods.sodium.common.util.collections.FutureQueueDrainingIterator;
import me.jellysquid.mods.sodium.common.util.collections.QueueDrainingIterator;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;

public class RenderSectionManager
implements ChunkStatusListener {
    private static final double NEARBY_CHUNK_DISTANCE = Math.pow(48.0, 2.0);
    private static final float FOG_PLANE_MIN_DISTANCE = (float)Math.pow(8.0, 2.0);
    private static final float FOG_PLANE_OFFSET = 12.0f;
    private final ChunkBuilder builder;
    private final ChunkRenderer chunkRenderer;
    private final RenderRegionManager regions;
    private final ClonedChunkSectionCache sectionCache;
    private final Long2ReferenceMap<RenderSection> sections = new Long2ReferenceOpenHashMap();
    private final ObjectArrayFIFOQueue<RenderSection> importantRebuildQueue = new ObjectArrayFIFOQueue();
    private final ObjectArrayFIFOQueue<RenderSection> rebuildQueue = new ObjectArrayFIFOQueue();
    private final Long2ReferenceMap<RenderChunkStatus> statusProcessingQueue = new Long2ReferenceLinkedOpenHashMap();
    private final ChunkAdjacencyMap adjacencyMap = new ChunkAdjacencyMap();
    private final Deque<ChunkBuildResult> uploadQueue = new ConcurrentLinkedDeque<ChunkBuildResult>();
    private final ChunkRenderList chunkRenderList = new ChunkRenderList();
    private final ChunkGraphIterationQueue iterationQueue = new ChunkGraphIterationQueue();
    private final ObjectList<RenderSection> tickableChunks = new ObjectArrayList();
    private final ObjectList<class_2586> visibleBlockEntities = new ObjectArrayList();
    private final SodiumWorldRenderer worldRenderer;
    private final class_638 world;
    private final int renderDistance;
    private float cameraX;
    private float cameraY;
    private float cameraZ;
    private int centerChunkX;
    private int centerChunkY;
    private int centerChunkZ;
    private boolean isGraphDirty;
    private boolean useFogCulling;
    private boolean useOcclusionCulling;
    private double fogRenderCutoff;
    private FrustumExtended frustum;
    private int activeFrame = 0;

    public RenderSectionManager(SodiumWorldRenderer worldRenderer, ChunkRenderer chunkRenderer, BlockRenderPassManager renderPassManager, class_638 world, int renderDistance) {
        this.chunkRenderer = chunkRenderer;
        this.worldRenderer = worldRenderer;
        this.world = world;
        this.builder = new ChunkBuilder(chunkRenderer.getVertexType());
        this.builder.init(world, renderPassManager);
        this.isGraphDirty = true;
        this.renderDistance = renderDistance;
        this.regions = new RenderRegionManager(this.chunkRenderer);
        this.sectionCache = new ClonedChunkSectionCache((class_1937)this.world);
        LongIterator it = ((ClientChunkManagerExtended)world.method_2935()).getLoadedChunks().iterator();
        while (it.hasNext()) {
            long pos = it.nextLong();
            this.onChunkAdded(class_1923.method_8325((long)pos), class_1923.method_8332((long)pos));
        }
    }

    private void updateRegionVisibilities(FrustumExtended frustum) {
        for (RenderRegion region : this.regions.getLoadedRegions()) {
            region.updateVisibility(frustum);
        }
    }

    public void update(class_4184 camera, FrustumExtended frustum, int frame, boolean spectator) {
        this.resetLists();
        this.processStatusChanges();
        this.updateRegionVisibilities(frustum);
        this.setup(camera);
        this.iterateChunks(camera, frustum, frame, spectator);
        this.isGraphDirty = false;
    }

    private void processStatusChanges() {
        if (this.statusProcessingQueue.isEmpty()) {
            return;
        }
        for (Long2ReferenceMap.Entry entry : this.statusProcessingQueue.long2ReferenceEntrySet()) {
            int x = class_1923.method_8325((long)entry.getLongKey());
            int z = class_1923.method_8332((long)entry.getLongKey());
            for (int y = this.world.method_32891(); y < this.world.method_31597(); ++y) {
                this.isGraphDirty |= this.processStatusChangeForSection(x, y, z, (RenderChunkStatus)((Object)entry.getValue()));
            }
            if (entry.getValue() == RenderChunkStatus.LOAD) {
                this.adjacencyMap.onChunkLoaded(x, z);
                continue;
            }
            if (entry.getValue() != RenderChunkStatus.UNLOAD) continue;
            this.adjacencyMap.onChunkUnloaded(x, z);
        }
        this.statusProcessingQueue.clear();
        this.isGraphDirty = true;
    }

    private boolean processStatusChangeForSection(int x, int y, int z, RenderChunkStatus status) {
        if (status == RenderChunkStatus.LOAD) {
            return this.loadSection(x, y, z);
        }
        if (status == RenderChunkStatus.UNLOAD) {
            return this.unloadSection(x, y, z);
        }
        throw new UnsupportedOperationException();
    }

    private void setup(class_4184 camera) {
        float dist;
        class_243 cameraPos = camera.method_19326();
        this.cameraX = (float)cameraPos.field_1352;
        this.cameraY = (float)cameraPos.field_1351;
        this.cameraZ = (float)cameraPos.field_1350;
        this.useFogCulling = false;
        if (SodiumClientMod.options().advanced.useFogOcclusion && (dist = RenderSystem.getShaderFogEnd() + 12.0f) != 0.0f) {
            this.useFogCulling = true;
            this.fogRenderCutoff = Math.max(FOG_PLANE_MIN_DISTANCE, dist * dist);
        }
    }

    private void iterateChunks(class_4184 camera, FrustumExtended frustum, int frame, boolean spectator) {
        this.initSearch(camera, frustum, frame, spectator);
        ChunkGraphIterationQueue queue = this.iterationQueue;
        for (int i = 0; i < queue.size(); ++i) {
            RenderSection parent = queue.getRender(i);
            class_2350 flow = queue.getDirection(i);
            for (class_2350 dir : DirectionUtil.ALL_DIRECTIONS) {
                RenderSection adj;
                if (this.isCulled(parent.getGraphInfo(), flow, dir) || (adj = parent.getAdjacent(dir)) == null || !this.isWithinRenderDistance(adj)) continue;
                this.bfsEnqueue(parent, adj, DirectionUtil.getOpposite(dir));
            }
        }
    }

    private boolean canBuildChunk(RenderSection render) {
        return this.adjacencyMap.hasNeighbors(render.getChunkX(), render.getChunkZ());
    }

    private void addChunkToVisible(RenderSection render) {
        this.chunkRenderList.add(render);
        if (render.isTickable()) {
            this.tickableChunks.add((Object)render);
        }
    }

    private void addEntitiesToRenderLists(RenderSection render) {
        Collection<class_2586> blockEntities = render.getData().getBlockEntities();
        if (!blockEntities.isEmpty()) {
            this.visibleBlockEntities.addAll(blockEntities);
        }
    }

    private void resetLists() {
        this.rebuildQueue.clear();
        this.importantRebuildQueue.clear();
        this.visibleBlockEntities.clear();
        this.chunkRenderList.clear();
        this.tickableChunks.clear();
    }

    public Collection<class_2586> getVisibleBlockEntities() {
        return this.visibleBlockEntities;
    }

    @Override
    public void onChunkAdded(int x, int z) {
        long key = class_1923.method_8331((int)x, (int)z);
        if (this.statusProcessingQueue.put(key, (Object)RenderChunkStatus.LOAD) == RenderChunkStatus.UNLOAD) {
            this.statusProcessingQueue.remove(key);
        }
    }

    @Override
    public void onChunkRemoved(int x, int z) {
        long key = class_1923.method_8331((int)x, (int)z);
        if (this.statusProcessingQueue.put(key, (Object)RenderChunkStatus.UNLOAD) == RenderChunkStatus.LOAD) {
            this.statusProcessingQueue.remove(key);
        }
    }

    private boolean loadSection(int x, int y, int z) {
        RenderRegion region = this.regions.createRegionForChunk(x, y, z);
        RenderSection render = new RenderSection(this.worldRenderer, x, y, z, region);
        region.addChunk(render);
        this.sections.put(class_4076.method_18685((int)x, (int)y, (int)z), (Object)render);
        class_2818 chunk = this.world.method_8497(x, z);
        class_2826 section = chunk.method_12006()[this.world.method_31603(y)];
        if (class_2826.method_18090((class_2826)section)) {
            render.setData(ChunkRenderData.EMPTY);
        } else {
            render.scheduleRebuild(false);
        }
        this.connectNeighborNodes(render);
        return true;
    }

    private boolean unloadSection(int x, int y, int z) {
        RenderSection chunk = (RenderSection)this.sections.remove(class_4076.method_18685((int)x, (int)y, (int)z));
        if (chunk == null) {
            throw new IllegalStateException("Chunk is not loaded: " + class_4076.method_18685((int)x, (int)y, (int)z));
        }
        chunk.delete();
        this.disconnectNeighborNodes(chunk);
        RenderRegion region = chunk.getRegion();
        region.removeChunk(chunk);
        if (region.isEmpty()) {
            this.regions.unloadRegion(region);
        }
        return true;
    }

    public void renderLayer(class_4587 matrixStack, BlockRenderPass pass, double x, double y, double z) {
        RenderDevice device = RenderDevice.INSTANCE;
        CommandList commandList = device.createCommandList();
        this.chunkRenderer.render(matrixStack, commandList, this.chunkRenderList, pass, new ChunkCameraContext(x, y, z));
        commandList.flush();
    }

    public void tickVisibleRenders() {
        for (RenderSection render : this.tickableChunks) {
            render.tick();
        }
    }

    public boolean isSectionVisible(int x, int y, int z) {
        RenderSection render = this.getRenderSection(x, y, z);
        if (render == null) {
            return false;
        }
        return render.getGraphInfo().getLastVisibleFrame() == this.activeFrame;
    }

    public void updateChunks() {
        RenderSection render;
        ArrayDeque blockingFutures = new ArrayDeque();
        int budget = this.builder.getSchedulingBudget();
        int submitted = 0;
        while (!this.importantRebuildQueue.isEmpty()) {
            render = (RenderSection)this.importantRebuildQueue.dequeue();
            if (!this.isChunkPrioritized(render)) {
                this.deferChunkRebuild(render);
            } else {
                blockingFutures.add(this.deferChunkRebuild(render));
            }
            this.isGraphDirty = true;
            ++submitted;
        }
        while (submitted < budget && !this.rebuildQueue.isEmpty()) {
            render = (RenderSection)this.rebuildQueue.dequeue();
            this.deferChunkRebuild(render);
            ++submitted;
        }
        this.isGraphDirty |= submitted > 0;
        this.isGraphDirty |= this.performPendingUploads();
        if (!blockingFutures.isEmpty()) {
            this.regions.upload(RenderDevice.INSTANCE.createCommandList(), new FutureQueueDrainingIterator<ChunkBuildResult>(blockingFutures));
        }
    }

    private boolean performPendingUploads() {
        this.uploadQueue.removeIf(result -> result.render.isDisposed());
        if (this.uploadQueue.isEmpty()) {
            return false;
        }
        this.regions.upload(RenderDevice.INSTANCE.createCommandList(), new QueueDrainingIterator<ChunkBuildResult>(this.uploadQueue));
        return true;
    }

    private CompletableFuture<ChunkBuildResult> deferChunkRebuild(RenderSection render) {
        ChunkRenderBuildTask task = this.createRebuildTask(render);
        CompletableFuture<ChunkBuildResult> future = this.builder.schedule(task);
        future.thenAccept(this.uploadQueue::add);
        render.setRebuildFuture(future);
        return future;
    }

    public ChunkRenderBuildTask createRebuildTask(RenderSection render) {
        if (render.isDisposed()) {
            throw new IllegalStateException("Tried to rebuild a chunk " + render + " but it has been disposed");
        }
        ChunkRenderContext context = WorldSlice.prepare((class_1937)this.world, render.getChunkPos(), this.sectionCache);
        if (context == null) {
            return new ChunkRenderEmptyBuildTask(render);
        }
        return new ChunkRenderRebuildTask(render, context);
    }

    public void markGraphDirty() {
        this.isGraphDirty = true;
    }

    public boolean isGraphDirty() {
        return this.isGraphDirty;
    }

    public ChunkBuilder getBuilder() {
        return this.builder;
    }

    public void destroy() {
        this.resetLists();
        this.regions.delete();
        this.builder.stopWorkers();
    }

    public int getTotalSections() {
        return this.regions.getLoadedRegions().stream().mapToInt(RenderRegion::getChunkCount).sum();
    }

    public int getVisibleChunkCount() {
        return this.chunkRenderList.getCount();
    }

    public void scheduleRebuild(int x, int y, int z, boolean important) {
        RenderSection render = (RenderSection)this.sections.get(class_4076.method_18685((int)x, (int)y, (int)z));
        if (render != null) {
            boolean bl = important = important || this.isChunkPrioritized(render);
            if (render.scheduleRebuild(important)) {
                (render.needsImportantRebuild() ? this.importantRebuildQueue : this.rebuildQueue).enqueue((Object)render);
            }
            this.isGraphDirty = true;
        }
        this.sectionCache.invalidate(x, y, z);
    }

    public boolean isChunkPrioritized(RenderSection render) {
        return render.getSquaredDistance(this.cameraX, this.cameraY, this.cameraZ) <= NEARBY_CHUNK_DISTANCE;
    }

    public void onChunkRenderUpdates(int x, int y, int z, ChunkRenderData data) {
        RenderSection node = this.getRenderSection(x, y, z);
        if (node != null) {
            node.setOcclusionData(data.getOcclusionData());
        }
    }

    private boolean isWithinRenderDistance(RenderSection adj) {
        int x = Math.abs(adj.getChunkX() - this.centerChunkX);
        int z = Math.abs(adj.getChunkZ() - this.centerChunkZ);
        return x <= this.renderDistance && z <= this.renderDistance;
    }

    private boolean isCulled(ChunkGraphInfo node, class_2350 from, class_2350 to) {
        if (node.canCull(to)) {
            return true;
        }
        return this.useOcclusionCulling && from != null && !node.isVisibleThrough(from, to);
    }

    private void initSearch(class_4184 camera, FrustumExtended frustum, int frame, boolean spectator) {
        this.activeFrame = frame;
        this.frustum = frustum;
        this.useOcclusionCulling = class_310.method_1551().field_1730;
        this.iterationQueue.clear();
        class_2338 origin = camera.method_19328();
        int chunkX = origin.method_10263() >> 4;
        int chunkY = origin.method_10264() >> 4;
        int chunkZ = origin.method_10260() >> 4;
        this.centerChunkX = chunkX;
        this.centerChunkY = chunkY;
        this.centerChunkZ = chunkZ;
        RenderSection rootRender = this.getRenderSection(chunkX, chunkY, chunkZ);
        if (rootRender != null) {
            ChunkGraphInfo rootInfo = rootRender.getGraphInfo();
            rootInfo.resetCullingState();
            rootInfo.setLastVisibleFrame(frame);
            if (spectator && this.world.method_8320(origin).method_26216((class_1922)this.world, origin)) {
                this.useOcclusionCulling = false;
            }
            this.addVisible(rootRender, null);
        } else {
            chunkY = class_3532.method_15340((int)(origin.method_10264() >> 4), (int)this.world.method_32891(), (int)(this.world.method_31597() - 1));
            ArrayList<RenderSection> sorted = new ArrayList<RenderSection>();
            for (int x2 = -this.renderDistance; x2 <= this.renderDistance; ++x2) {
                for (int z2 = -this.renderDistance; z2 <= this.renderDistance; ++z2) {
                    ChunkGraphInfo info;
                    RenderSection render = this.getRenderSection(chunkX + x2, chunkY, chunkZ + z2);
                    if (render == null || (info = render.getGraphInfo()).isCulledByFrustum(frustum)) continue;
                    info.resetCullingState();
                    info.setLastVisibleFrame(frame);
                    sorted.add(render);
                }
            }
            sorted.sort(Comparator.comparingDouble(node -> node.getSquaredDistance(origin)));
            for (RenderSection render : sorted) {
                this.addVisible(render, null);
            }
        }
    }

    private void bfsEnqueue(RenderSection parent, RenderSection render, class_2350 flow) {
        ChunkGraphInfo info = render.getGraphInfo();
        if (info.getLastVisibleFrame() == this.activeFrame) {
            return;
        }
        RenderRegionVisibility parentVisibility = parent.getRegion().getVisibility();
        if (parentVisibility == RenderRegionVisibility.CULLED) {
            return;
        }
        if (parentVisibility == RenderRegionVisibility.VISIBLE && info.isCulledByFrustum(this.frustum)) {
            return;
        }
        info.setLastVisibleFrame(this.activeFrame);
        info.setCullingState(parent.getGraphInfo().getCullingState(), flow);
        this.addVisible(render, flow);
    }

    private void addVisible(RenderSection render, class_2350 flow) {
        this.iterationQueue.add(render, flow);
        if (render.needsRebuild() && this.canBuildChunk(render)) {
            if (render.needsImportantRebuild()) {
                this.importantRebuildQueue.enqueue((Object)render);
            } else {
                this.rebuildQueue.enqueue((Object)render);
            }
        }
        if (this.useFogCulling && render.getSquaredDistanceXZ(this.cameraX, this.cameraZ) >= this.fogRenderCutoff) {
            return;
        }
        if (!render.isEmpty()) {
            this.addChunkToVisible(render);
            this.addEntitiesToRenderLists(render);
        }
    }

    private void connectNeighborNodes(RenderSection render) {
        for (class_2350 dir : DirectionUtil.ALL_DIRECTIONS) {
            RenderSection adj = this.getRenderSection(render.getChunkX() + dir.method_10148(), render.getChunkY() + dir.method_10164(), render.getChunkZ() + dir.method_10165());
            if (adj == null) continue;
            adj.setAdjacentNode(DirectionUtil.getOpposite(dir), render);
            render.setAdjacentNode(dir, adj);
        }
    }

    private void disconnectNeighborNodes(RenderSection render) {
        for (class_2350 dir : DirectionUtil.ALL_DIRECTIONS) {
            RenderSection adj = render.getAdjacent(dir);
            if (adj == null) continue;
            adj.setAdjacentNode(DirectionUtil.getOpposite(dir), null);
            render.setAdjacentNode(dir, null);
        }
    }

    private RenderSection getRenderSection(int x, int y, int z) {
        return (RenderSection)this.sections.get(class_4076.method_18685((int)x, (int)y, (int)z));
    }

    static enum RenderChunkStatus {
        LOAD,
        UNLOAD;

    }
}

