/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.format.sfp;

import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttributeFormat;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.type.BlittableVertexType;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.format.ChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.render.chunk.format.sfp.ModelVertexBufferWriterNio;
import me.jellysquid.mods.sodium.client.render.chunk.format.sfp.ModelVertexBufferWriterUnsafe;
import net.minecraft.class_4588;

public class ModelVertexType
implements ChunkVertexType {
    public static final GlVertexFormat<ChunkMeshAttribute> VERTEX_FORMAT = GlVertexFormat.builder(ChunkMeshAttribute.class, 24).addElement(ChunkMeshAttribute.OFFSET, 0, GlVertexAttributeFormat.UNSIGNED_BYTE, 3, false).addElement(ChunkMeshAttribute.POSITION, 4, GlVertexAttributeFormat.UNSIGNED_SHORT, 4, false).addElement(ChunkMeshAttribute.COLOR, 12, GlVertexAttributeFormat.UNSIGNED_BYTE, 4, true).addElement(ChunkMeshAttribute.BLOCK_TEXTURE, 16, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, false).addElement(ChunkMeshAttribute.LIGHT_TEXTURE, 20, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, true).build();
    private static final int POSITION_MAX_VALUE = 32768;
    private static final int TEXTURE_MAX_VALUE = 32768;
    private static final float MODEL_ORIGIN = 4.0f;
    private static final float MODEL_RANGE = 8.0f;
    private static final float MODEL_SCALE = 2.4414062E-4f;
    private static final float MODEL_SCALE_INV = 4096.0f;
    private static final float TEXTURE_SCALE = 3.0517578E-5f;

    @Override
    public ModelVertexSink createFallbackWriter(class_4588 consumer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ModelVertexSink createBufferWriter(VertexBufferView buffer, boolean direct) {
        return direct ? new ModelVertexBufferWriterUnsafe(buffer) : new ModelVertexBufferWriterNio(buffer);
    }

    @Override
    public BlittableVertexType<ModelVertexSink> asBlittable() {
        return this;
    }

    @Override
    public GlVertexFormat<ChunkMeshAttribute> getCustomVertexFormat() {
        return VERTEX_FORMAT;
    }

    @Override
    public float getTextureScale() {
        return 3.0517578E-5f;
    }

    @Override
    public float getModelScale() {
        return 2.4414062E-4f;
    }

    @Override
    public float getModelOffset() {
        return -4.0f;
    }

    static short encodeBlockTexture(float value) {
        return (short)(value * 32768.0f);
    }

    static short encodePosition(float v) {
        return (short)((4.0f + v) * 4096.0f);
    }

    static int encodeLightMapTexCoord(int light) {
        int r = light;
        r &= 0xFF00FF;
        r <<= 8;
        return r += 0x8000800;
    }
}

