/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.graph;

import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.class_2350;
import net.minecraft.class_854;

public class ChunkGraphInfo {
    private static final long DEFAULT_VISIBILITY_DATA = ChunkGraphInfo.calculateVisibilityData(ChunkRenderData.EMPTY.getOcclusionData());
    private final RenderSection parent;
    private int lastVisibleFrame = -1;
    private long visibilityData;
    private byte cullingState;

    public ChunkGraphInfo(RenderSection parent) {
        this.parent = parent;
        this.visibilityData = DEFAULT_VISIBILITY_DATA;
    }

    public void setLastVisibleFrame(int frame) {
        this.lastVisibleFrame = frame;
    }

    public int getLastVisibleFrame() {
        return this.lastVisibleFrame;
    }

    public void setOcclusionData(class_854 occlusionData) {
        this.visibilityData = ChunkGraphInfo.calculateVisibilityData(occlusionData);
    }

    private static long calculateVisibilityData(class_854 occlusionData) {
        long visibilityData = 0L;
        for (class_2350 from : DirectionUtil.ALL_DIRECTIONS) {
            for (class_2350 to : DirectionUtil.ALL_DIRECTIONS) {
                if (occlusionData != null && !occlusionData.method_3695(from, to)) continue;
                visibilityData |= 1L << (from.ordinal() << 3) + to.ordinal();
            }
        }
        return visibilityData;
    }

    public boolean isVisibleThrough(class_2350 from, class_2350 to) {
        return (this.visibilityData & 1L << (from.ordinal() << 3) + to.ordinal()) != 0L;
    }

    public void setCullingState(byte parent, class_2350 dir) {
        this.cullingState = (byte)(parent | 1 << dir.ordinal());
    }

    public boolean canCull(class_2350 dir) {
        return (this.cullingState & 1 << dir.ordinal()) != 0;
    }

    public byte getCullingState() {
        return this.cullingState;
    }

    public void resetCullingState() {
        this.cullingState = 0;
    }

    public boolean isCulledByFrustum(FrustumExtended frustum) {
        float z;
        float y;
        float x = this.getOriginX();
        return !frustum.fastAabbTest(x, y = (float)this.getOriginY(), z = (float)this.getOriginZ(), x + 16.0f, y + 16.0f, z + 16.0f);
    }

    public int getOriginX() {
        return this.parent.getChunkX() << 4;
    }

    public int getOriginY() {
        return this.parent.getChunkY() << 4;
    }

    public int getOriginZ() {
        return this.parent.getChunkZ() << 4;
    }

    public RenderSection getParent() {
        return this.parent;
    }
}

