/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.common.util.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;

public class FutureQueueDrainingIterator<T>
implements Iterator<T> {
    private final Queue<CompletableFuture<T>> queue;
    private T next = null;

    public FutureQueueDrainingIterator(Queue<CompletableFuture<T>> queue) {
        this.queue = queue;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        this.findNext();
        return this.next != null;
    }

    private void findNext() {
        while (!this.queue.isEmpty()) {
            CompletableFuture<T> future = this.queue.remove();
            try {
                this.next = future.join();
                return;
            }
            catch (CancellationException cancellationException) {
            }
        }
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.next;
        this.next = null;
        return result;
    }
}

