/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadWinding;

public class IndexBufferBuilder {
    private final IntArrayList indices;

    public IndexBufferBuilder(int count) {
        this.indices = new IntArrayList(count);
    }

    public void add(int start, ModelQuadWinding winding) {
        for (int index : winding.getIndices()) {
            this.indices.add(start + index);
        }
    }

    public void get(ByteBuffer buffer) {
        IntListIterator it = this.indices.iterator();
        while (it.hasNext()) {
            buffer.putInt(it.nextInt());
        }
    }

    public int getSize() {
        return this.getCount() * 4;
    }

    public void start() {
        this.indices.clear();
    }

    public int getCount() {
        return this.indices.size();
    }
}

