/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.gl.shader.GlShader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderConstants;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderLoader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderType;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.format.ChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkFogMode;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkProgram;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderBindingPoints;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderOptions;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public abstract class ShaderChunkRenderer
implements ChunkRenderer {
    private final Map<BlockRenderPass, Map<ChunkShaderOptions, ChunkProgram>> programs = new Object2ObjectOpenHashMap();
    protected final ChunkVertexType vertexType;
    protected final GlVertexFormat<ChunkMeshAttribute> vertexFormat;
    protected final RenderDevice device;
    protected ChunkProgram activeProgram;

    public ShaderChunkRenderer(RenderDevice device, ChunkVertexType vertexType) {
        this.device = device;
        this.vertexType = vertexType;
        this.vertexFormat = vertexType.getCustomVertexFormat();
    }

    protected ChunkProgram compileProgram(BlockRenderPass pass, ChunkShaderOptions options) {
        ChunkProgram program;
        Object2ObjectOpenHashMap programs = this.programs.get((Object)pass);
        if (programs == null) {
            programs = new Object2ObjectOpenHashMap();
            this.programs.put(pass, (Map<ChunkShaderOptions, ChunkProgram>)programs);
        }
        if ((program = programs.get(options)) == null) {
            program = this.createShader(this.device, this.getShaderName(pass), options);
            programs.put(options, program);
        }
        return program;
    }

    protected String getShaderName(BlockRenderPass pass) {
        return switch (pass) {
            case BlockRenderPass.CUTOUT -> "blocks/block_layer_cutout";
            case BlockRenderPass.CUTOUT_MIPPED -> "blocks/block_layer_cutout_mipped";
            case BlockRenderPass.TRANSLUCENT, BlockRenderPass.TRIPWIRE -> "blocks/block_layer_translucent";
            default -> "blocks/block_layer_solid";
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkProgram createShader(RenderDevice device, String path, ChunkShaderOptions options) {
        ShaderConstants constants = options.constants();
        GlShader vertShader = ShaderLoader.loadShader(ShaderType.VERTEX, new class_2960("sodium", path + ".vsh"), constants);
        GlShader fragShader = ShaderLoader.loadShader(ShaderType.FRAGMENT, new class_2960("sodium", path + ".fsh"), constants);
        try {
            ChunkProgram chunkProgram = GlProgram.builder(new class_2960("sodium", "chunk_shader")).attachShader(vertShader).attachShader(fragShader).bindAttribute("a_Pos", ChunkShaderBindingPoints.ATTRIBUTE_POSITION_ID).bindAttribute("a_Color", ChunkShaderBindingPoints.ATTRIBUTE_COLOR).bindAttribute("a_TexCoord", ChunkShaderBindingPoints.ATTRIBUTE_BLOCK_TEXTURE).bindAttribute("a_LightCoord", ChunkShaderBindingPoints.ATTRIBUTE_LIGHT_TEXTURE).bindFragmentData("fragColor", ChunkShaderBindingPoints.FRAG_COLOR).build(name -> new ChunkProgram(device, name, options));
            return chunkProgram;
        }
        finally {
            vertShader.delete();
            fragShader.delete();
        }
    }

    protected void begin(BlockRenderPass pass, class_4587 matrixStack) {
        ChunkShaderOptions options = new ChunkShaderOptions(ChunkFogMode.SMOOTH);
        this.activeProgram = this.compileProgram(pass, options);
        this.activeProgram.bind();
        this.activeProgram.setup(matrixStack, this.vertexType);
    }

    protected void end() {
        this.activeProgram.unbind();
        this.activeProgram = null;
    }

    @Override
    public void delete() {
        this.programs.values().stream().flatMap(i -> i.values().stream()).forEach(GlProgram::delete);
        this.programs.clear();
    }

    @Override
    public ChunkVertexType getVertexType() {
        return this.vertexType;
    }
}

