/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.stream.Collectors;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.MemoryUtil;

public class NativeBuffer {
    private static final Logger LOGGER = LogManager.getLogger(NativeBuffer.class);
    private static final ReferenceQueue<NativeBuffer> RECLAIM_QUEUE = new ReferenceQueue();
    private static final Reference2ReferenceMap<Reference<NativeBuffer>, BufferReference> ACTIVE_BUFFERS = Reference2ReferenceMaps.synchronize((Reference2ReferenceMap)new Reference2ReferenceOpenHashMap());
    private static long ALLOCATED = 0L;
    private final BufferReference ref;
    private static final int MAX_ALLOCATION_ATTEMPTS = 3;

    public NativeBuffer(int capacity) {
        this.ref = NativeBuffer.allocate(capacity);
        ACTIVE_BUFFERS.put(new PhantomReference<NativeBuffer>(this, RECLAIM_QUEUE), (Object)this.ref);
    }

    public ByteBuffer getDirectBuffer() {
        this.ref.checkFreed();
        return MemoryUtil.memByteBuffer((long)this.ref.address, (int)this.ref.length);
    }

    public void free() {
        NativeBuffer.deallocate(this.ref);
    }

    public int size() {
        return this.ref.length;
    }

    public static void reclaim(boolean forceGc) {
        Reference<NativeBuffer> ref;
        if (forceGc) {
            System.gc();
        }
        while ((ref = RECLAIM_QUEUE.poll()) != null) {
            BufferReference buf = (BufferReference)ACTIVE_BUFFERS.remove(ref);
            if (buf.freed) continue;
            NativeBuffer.deallocate(buf);
            if (buf.allocationSite != null) {
                LOGGER.warn("Reclaimed {} bytes at address {} that were leaked from allocation site:\n{}", (Object)buf.length, (Object)buf.address, (Object)Arrays.stream(buf.allocationSite).map(StackTraceElement::toString).collect(Collectors.joining("\n")));
                continue;
            }
            LOGGER.warn("Reclaimed {} bytes at address {} that were leaked from an unknown location (logging is disabled)", (Object)buf.length, (Object)buf.address);
        }
    }

    public static long getTotalAllocated() {
        return ALLOCATED;
    }

    private static StackTraceElement[] getStackTrace() {
        return SodiumClientMod.options().advanced.enableMemoryTracing ? Thread.currentThread().getStackTrace() : null;
    }

    private static BufferReference allocate(int bytes) {
        long address = 0L;
        int attempts = 0;
        while (++attempts <= 3 && (address = MemoryUtil.nmemAlloc((long)bytes)) == 0L) {
            LOGGER.error("EMERGENCY: Tried to allocate {} bytes but the allocator reports failure", (Object)bytes);
            LOGGER.error("EMERGENCY: ... Attempting to force a garbage collection cycle (attempt {}/{})", (Object)attempts, (Object)3);
            NativeBuffer.reclaim(true);
        }
        if (address == 0L) {
            throw new OutOfMemoryError("Couldn't allocate %s bytes after %s attempts".formatted(bytes, attempts));
        }
        StackTraceElement[] stackTrace = NativeBuffer.getStackTrace();
        BufferReference ref = new BufferReference(address, bytes, stackTrace);
        ALLOCATED += (long)ref.length;
        return ref;
    }

    private static void deallocate(BufferReference ref) {
        ref.checkFreed();
        ref.freed = true;
        MemoryUtil.nmemFree((long)ref.address);
        ALLOCATED -= (long)ref.length;
    }

    private static class BufferReference {
        public final long address;
        public final int length;
        public final StackTraceElement[] allocationSite;
        public boolean freed;

        private BufferReference(long address, int length, StackTraceElement[] allocationSite) {
            this.address = address;
            this.length = length;
            this.allocationSite = allocationSite;
        }

        private void checkFreed() {
            if (this.freed) {
                throw new IllegalStateException("Buffer has been deleted");
            }
        }
    }
}

