/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.arena;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferSegment;
import me.jellysquid.mods.sodium.client.gl.arena.PendingBufferCopyCommand;
import me.jellysquid.mods.sodium.client.gl.arena.PendingUpload;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBufferUsage;
import me.jellysquid.mods.sodium.client.gl.buffer.GlMutableBuffer;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;

public class GlBufferArena {
    static final boolean CHECK_ASSERTIONS = false;
    private static final GlBufferUsage BUFFER_USAGE = GlBufferUsage.DYNAMIC_DRAW;
    private final int stride;
    private final long resizeIncrement;
    private final GlMutableBuffer stagingBuffer;
    private GlMutableBuffer arenaBuffer;
    private GlBufferSegment head;
    private long capacity;
    private long used;

    private GlBufferArena(CommandList commands, long initialCapacity, int stride) {
        this.stride = stride;
        this.resizeIncrement = initialCapacity / 16L;
        this.capacity = initialCapacity;
        this.head = new GlBufferSegment(this, 0L, initialCapacity);
        this.head.setFree(true);
        this.arenaBuffer = commands.createMutableBuffer();
        commands.allocateStorage(this.arenaBuffer, this.toBytes(initialCapacity), BUFFER_USAGE);
        this.stagingBuffer = commands.createMutableBuffer();
    }

    public static GlBufferArena createIndexArena(CommandList commandList, int initialCapacity) {
        return new GlBufferArena(commandList, initialCapacity, 1);
    }

    public static GlBufferArena createVertexArena(CommandList commandList, int initialCapacity, int stride) {
        return new GlBufferArena(commandList, initialCapacity, stride);
    }

    private void resize(CommandList commandList, long newCapacity) {
        if (this.used > newCapacity) {
            throw new UnsupportedOperationException("New capacity must be larger than used size");
        }
        this.checkAssertions();
        long base = newCapacity - this.used;
        ArrayList<GlBufferSegment> usedSegments = this.getUsedSegments();
        List<PendingBufferCopyCommand> pendingCopies = this.buildTransferList(usedSegments, base);
        this.transferSegments(commandList, pendingCopies, newCapacity);
        this.head = new GlBufferSegment(this, 0L, base);
        this.head.setFree(true);
        if (usedSegments.isEmpty()) {
            this.head.setNext(null);
        } else {
            this.head.setNext((GlBufferSegment)usedSegments.get(0));
            this.head.getNext().setPrev(this.head);
        }
        this.checkAssertions();
    }

    private List<PendingBufferCopyCommand> buildTransferList(List<GlBufferSegment> usedSegments, long base) {
        ArrayList<PendingBufferCopyCommand> pendingCopies = new ArrayList<PendingBufferCopyCommand>();
        PendingBufferCopyCommand currentCopyCommand = null;
        long writeOffset = base;
        for (int i = 0; i < usedSegments.size(); ++i) {
            GlBufferSegment s = usedSegments.get(i);
            if (currentCopyCommand == null || currentCopyCommand.writeOffset + currentCopyCommand.length != s.getOffset()) {
                if (currentCopyCommand != null) {
                    pendingCopies.add(currentCopyCommand);
                }
                currentCopyCommand = new PendingBufferCopyCommand(s.getOffset(), writeOffset, s.getLength());
            } else {
                currentCopyCommand.length += s.getLength();
            }
            s.setOffset(writeOffset);
            if (i + 1 < usedSegments.size()) {
                s.setNext(usedSegments.get(i + 1));
            } else {
                s.setNext(null);
            }
            if (i - 1 < 0) {
                s.setPrev(null);
            } else {
                s.setPrev(usedSegments.get(i - 1));
            }
            writeOffset += s.getLength();
        }
        if (currentCopyCommand != null) {
            pendingCopies.add(currentCopyCommand);
        }
        return pendingCopies;
    }

    private void transferSegments(CommandList commandList, Collection<PendingBufferCopyCommand> list, long capacity) {
        GlMutableBuffer srcBufferObj = this.arenaBuffer;
        GlMutableBuffer dstBufferObj = commandList.createMutableBuffer();
        commandList.allocateStorage(dstBufferObj, this.toBytes(capacity), BUFFER_USAGE);
        for (PendingBufferCopyCommand cmd : list) {
            commandList.copyBufferSubData(srcBufferObj, dstBufferObj, this.toBytes(cmd.readOffset), this.toBytes(cmd.writeOffset), this.toBytes(cmd.length));
        }
        commandList.deleteBuffer(srcBufferObj);
        this.arenaBuffer = dstBufferObj;
        this.capacity = capacity;
    }

    private ArrayList<GlBufferSegment> getUsedSegments() {
        ArrayList<GlBufferSegment> used = new ArrayList<GlBufferSegment>();
        GlBufferSegment seg = this.head;
        while (seg != null) {
            GlBufferSegment next = seg.getNext();
            if (!seg.isFree()) {
                used.add(seg);
            }
            seg = next;
        }
        return used;
    }

    public long getUsedMemory() {
        return this.toBytes(this.used);
    }

    public long getAllocatedMemory() {
        return this.toBytes(this.capacity);
    }

    private GlBufferSegment alloc(long size) {
        GlBufferSegment result;
        GlBufferSegment a = this.findFree(size);
        if (a == null) {
            return null;
        }
        if (a.getLength() == size) {
            a.setFree(false);
            result = a;
        } else {
            GlBufferSegment b = new GlBufferSegment(this, a.getEnd() - size, size);
            b.setNext(a.getNext());
            b.setPrev(a);
            if (b.getNext() != null) {
                b.getNext().setPrev(b);
            }
            a.setLength(a.getLength() - size);
            a.setNext(b);
            result = b;
        }
        this.used += result.getLength();
        this.checkAssertions();
        return result;
    }

    private GlBufferSegment findFree(long size) {
        GlBufferSegment best = null;
        for (GlBufferSegment entry = this.head; entry != null; entry = entry.getNext()) {
            if (!entry.isFree()) continue;
            if (entry.getLength() == size) {
                return entry;
            }
            if (entry.getLength() < size || best != null && best.getLength() <= entry.getLength()) continue;
            best = entry;
        }
        return best;
    }

    public void free(GlBufferSegment entry) {
        GlBufferSegment prev;
        if (entry.isFree()) {
            throw new IllegalStateException("Already freed");
        }
        entry.setFree(true);
        this.used -= entry.getLength();
        GlBufferSegment next = entry.getNext();
        if (next != null && next.isFree()) {
            entry.mergeInto(next);
        }
        if ((prev = entry.getPrev()) != null && prev.isFree()) {
            prev.mergeInto(entry);
        }
        this.checkAssertions();
    }

    public void delete(CommandList commands) {
        commands.deleteBuffer(this.arenaBuffer);
        commands.deleteBuffer(this.stagingBuffer);
    }

    public boolean isEmpty() {
        return this.used <= 0L;
    }

    public GlBuffer getBufferObject() {
        return this.arenaBuffer;
    }

    public boolean upload(CommandList commandList, Stream<PendingUpload> stream) {
        GlMutableBuffer buffer = this.arenaBuffer;
        List queue = stream.collect(Collectors.toCollection(LinkedList::new));
        queue.removeIf(upload -> this.tryUpload(commandList, (PendingUpload)upload));
        if (!queue.isEmpty()) {
            int remainingElements = queue.stream().mapToInt(upload -> this.toElements(upload.getDataBuffer().getLength())).sum();
            this.ensureCapacity(commandList, remainingElements);
            queue.removeIf(upload -> this.tryUpload(commandList, (PendingUpload)upload));
            if (!queue.isEmpty()) {
                throw new RuntimeException("Failed to upload all buffers");
            }
        }
        commandList.uploadData(this.stagingBuffer, null, GlBufferUsage.STREAM_DRAW);
        return this.arenaBuffer != buffer;
    }

    private boolean tryUpload(CommandList commandList, PendingUpload upload) {
        ByteBuffer data = upload.getDataBuffer().getDirectBuffer();
        int elementCount = this.toElements(data.remaining());
        GlBufferSegment dst = this.alloc(elementCount);
        if (dst == null) {
            return false;
        }
        commandList.uploadData(this.stagingBuffer, data, GlBufferUsage.STREAM_DRAW);
        commandList.copyBufferSubData(this.stagingBuffer, this.arenaBuffer, 0L, this.toBytes(dst.getOffset()), this.toBytes(dst.getLength()));
        upload.setResult(dst);
        return true;
    }

    public void ensureCapacity(CommandList commandList, int elementCount) {
        long elementsNeeded = (long)elementCount - (this.capacity - this.used);
        this.resize(commandList, Math.max(this.capacity + this.resizeIncrement, this.capacity + elementsNeeded));
    }

    private void checkAssertions() {
    }

    private void checkAssertions0() {
        GlBufferSegment seg = this.head;
        long used = 0L;
        while (seg != null) {
            GlBufferSegment prev;
            GlBufferSegment next;
            if (seg.getOffset() < 0L) {
                throw new IllegalStateException("segment.start < 0: out of bounds");
            }
            if (seg.getEnd() > this.capacity) {
                throw new IllegalStateException("segment.end > arena.capacity: out of bounds");
            }
            if (!seg.isFree()) {
                used += seg.getLength();
            }
            if ((next = seg.getNext()) != null) {
                if (next.getOffset() < seg.getEnd()) {
                    throw new IllegalStateException("segment.next.start < segment.end: overlapping segments (corrupted)");
                }
                if (next.getOffset() > seg.getEnd()) {
                    throw new IllegalStateException("segment.next.start > segment.end: not truly connected (sparsity error)");
                }
                if (next.isFree() && next.getNext() != null && next.getNext().isFree()) {
                    throw new IllegalStateException("segment.free && segment.next.free: not merged consecutive segments");
                }
            }
            if ((prev = seg.getPrev()) != null) {
                if (prev.getEnd() > seg.getOffset()) {
                    throw new IllegalStateException("segment.prev.end > segment.start: overlapping segments (corrupted)");
                }
                if (prev.getEnd() < seg.getOffset()) {
                    throw new IllegalStateException("segment.prev.end < segment.start: not truly connected (sparsity error)");
                }
                if (prev.isFree() && prev.getPrev() != null && prev.getPrev().isFree()) {
                    throw new IllegalStateException("segment.free && segment.prev.free: not merged consecutive segments");
                }
            }
            seg = next;
        }
        if (this.used < 0L) {
            throw new IllegalStateException("arena.used < 0: failure to track");
        }
        if (this.used > this.capacity) {
            throw new IllegalStateException("arena.used > arena.capacity: failure to track");
        }
        if (this.used != used) {
            throw new IllegalStateException("arena.used is invalid");
        }
    }

    private long toBytes(long elementCount) {
        return elementCount * (long)this.stride;
    }

    private int toElements(long bytes) {
        if (this.stride == 1) {
            return (int)bytes;
        }
        return (int)(bytes / (long)this.stride);
    }
}

