/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.jellysquid.mods.sodium.client.gui.options.TextProvider;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_5365;

public class SodiumGameOptions {
    public final QualitySettings quality = new QualitySettings();
    public final AdvancedSettings advanced = new AdvancedSettings();
    public final NotificationSettings notifications = new NotificationSettings();
    private Path configPath;
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();

    public static SodiumGameOptions load(Path path) {
        SodiumGameOptions config;
        block10: {
            if (Files.exists(path, new LinkOption[0])) {
                try (FileReader reader = new FileReader(path.toFile());){
                    config = (SodiumGameOptions)GSON.fromJson((Reader)reader, SodiumGameOptions.class);
                    break block10;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not parse config", e);
                }
            }
            config = new SodiumGameOptions();
        }
        config.configPath = path;
        try {
            config.writeChanges();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't update config file", e);
        }
        return config;
    }

    public void writeChanges() throws IOException {
        Path dir = this.configPath.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Not a directory: " + dir);
        }
        Files.writeString(this.configPath, (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
    }

    public static class QualitySettings {
        public GraphicsQuality cloudQuality = GraphicsQuality.DEFAULT;
        public GraphicsQuality weatherQuality = GraphicsQuality.DEFAULT;
        public boolean enableVignette = true;
        public boolean enableClouds = true;
    }

    public static class AdvancedSettings {
        public boolean animateOnlyVisibleTextures = true;
        public boolean useEntityCulling = true;
        public boolean useParticleCulling = true;
        public boolean useFogOcclusion = true;
        public boolean useBlockFaceCulling = true;
        public boolean allowDirectMemoryAccess = true;
        public boolean enableMemoryTracing = false;
    }

    public static class NotificationSettings {
        public boolean hideDonationButton = false;
    }

    public static enum GraphicsQuality implements TextProvider
    {
        DEFAULT("generator.default"),
        FANCY("options.clouds.fancy"),
        FAST("options.clouds.fast");

        private final class_2561 name;

        private GraphicsQuality(String name) {
            this.name = new class_2588(name);
        }

        @Override
        public class_2561 getLocalizedName() {
            return this.name;
        }

        public boolean isFancy(class_5365 graphicsMode) {
            return this == FANCY || this == DEFAULT && (graphicsMode == class_5365.field_25428 || graphicsMode == class_5365.field_25429);
        }
    }
}

