/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.Map;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttributeBinding;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBufferUsage;
import me.jellysquid.mods.sodium.client.gl.buffer.GlMutableBuffer;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.DrawCommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.tessellation.GlIndexType;
import me.jellysquid.mods.sodium.client.gl.tessellation.GlPrimitiveType;
import me.jellysquid.mods.sodium.client.gl.tessellation.GlTessellation;
import me.jellysquid.mods.sodium.client.gl.tessellation.TessellationBinding;
import me.jellysquid.mods.sodium.client.gl.util.ElementRange;
import me.jellysquid.mods.sodium.client.gl.util.MultiDrawBatch;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkCameraContext;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.ShaderChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.format.ChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderBindingPoints;
import net.minecraft.class_4587;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryStack;

public class RegionChunkRenderer
extends ShaderChunkRenderer {
    private final MultiDrawBatch[] batches;
    private final GlVertexAttributeBinding[] vertexAttributeBindings;
    private final GlMutableBuffer chunkInfoBuffer;

    public RegionChunkRenderer(RenderDevice device, ChunkVertexType vertexType) {
        super(device, vertexType);
        this.vertexAttributeBindings = new GlVertexAttributeBinding[]{new GlVertexAttributeBinding(ChunkShaderBindingPoints.ATTRIBUTE_POSITION_ID, this.vertexFormat.getAttribute(ChunkMeshAttribute.POSITION_ID)), new GlVertexAttributeBinding(ChunkShaderBindingPoints.ATTRIBUTE_COLOR, this.vertexFormat.getAttribute(ChunkMeshAttribute.COLOR)), new GlVertexAttributeBinding(ChunkShaderBindingPoints.ATTRIBUTE_BLOCK_TEXTURE, this.vertexFormat.getAttribute(ChunkMeshAttribute.BLOCK_TEXTURE)), new GlVertexAttributeBinding(ChunkShaderBindingPoints.ATTRIBUTE_LIGHT_TEXTURE, this.vertexFormat.getAttribute(ChunkMeshAttribute.LIGHT_TEXTURE))};
        try (CommandList commandList = device.createCommandList();){
            this.chunkInfoBuffer = commandList.createMutableBuffer();
            try (MemoryStack stack = MemoryStack.stackPush();){
                commandList.uploadData(this.chunkInfoBuffer, RegionChunkRenderer.createChunkInfoBuffer(stack), GlBufferUsage.STATIC_DRAW);
            }
        }
        this.batches = new MultiDrawBatch[GlIndexType.VALUES.length];
        for (int i = 0; i < this.batches.length; ++i) {
            this.batches[i] = MultiDrawBatch.create(ModelQuadFacing.COUNT * 256);
        }
    }

    private static ByteBuffer createChunkInfoBuffer(MemoryStack stack) {
        int stride = 16;
        ByteBuffer data = stack.malloc(256 * stride);
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 8; ++z) {
                    int i = RenderRegion.getChunkIndex(x, y, z) * stride;
                    data.putFloat(i + 0, (float)x * 16.0f);
                    data.putFloat(i + 4, (float)y * 16.0f);
                    data.putFloat(i + 8, (float)z * 16.0f);
                }
            }
        }
        return data;
    }

    @Override
    public void render(class_4587 matrixStack, CommandList commandList, ChunkRenderList list, BlockRenderPass pass, ChunkCameraContext camera) {
        super.begin(pass, matrixStack);
        this.bindDrawParameters();
        for (Map.Entry<RenderRegion, List<RenderSection>> entry : RegionChunkRenderer.sortedRegions(list, pass.isTranslucent())) {
            RenderRegion region = entry.getKey();
            List<RenderSection> regionSections = entry.getValue();
            if (!this.buildDrawBatches(regionSections, pass, camera)) continue;
            this.pushCameraTranslation(region, camera);
            GlTessellation tessellation = this.createTessellationForRegion(commandList, region.getArenas(pass));
            this.executeDrawBatches(commandList, tessellation);
        }
        super.end();
    }

    private void bindDrawParameters() {
        GL32C.glBindBufferBase((int)35345, (int)0, (int)this.chunkInfoBuffer.handle());
        GL32C.glUniformBlockBinding((int)this.activeProgram.handle(), (int)this.activeProgram.uboDrawParametersIndex, (int)0);
    }

    private boolean buildDrawBatches(List<RenderSection> sections, BlockRenderPass pass, ChunkCameraContext camera) {
        for (MultiDrawBatch batch : this.batches) {
            batch.begin();
        }
        for (RenderSection render : RegionChunkRenderer.sortedChunks(sections, pass.isTranslucent())) {
            ChunkGraphicsState state = render.getGraphicsState(pass);
            if (state == null) continue;
            ChunkRenderBounds bounds = render.getBounds();
            long indexOffset = state.getIndexSegment().getOffset();
            int baseVertex = (int)state.getVertexSegment().getOffset();
            this.addDrawCall(state.getModelPart(ModelQuadFacing.UNASSIGNED), indexOffset, baseVertex);
            if (camera.posY > bounds.y1) {
                this.addDrawCall(state.getModelPart(ModelQuadFacing.UP), indexOffset, baseVertex);
            }
            if (camera.posY < bounds.y2) {
                this.addDrawCall(state.getModelPart(ModelQuadFacing.DOWN), indexOffset, baseVertex);
            }
            if (camera.posX > bounds.x1) {
                this.addDrawCall(state.getModelPart(ModelQuadFacing.EAST), indexOffset, baseVertex);
            }
            if (camera.posX < bounds.x2) {
                this.addDrawCall(state.getModelPart(ModelQuadFacing.WEST), indexOffset, baseVertex);
            }
            if (camera.posZ > bounds.z1) {
                this.addDrawCall(state.getModelPart(ModelQuadFacing.SOUTH), indexOffset, baseVertex);
            }
            if (!(camera.posZ < bounds.z2)) continue;
            this.addDrawCall(state.getModelPart(ModelQuadFacing.NORTH), indexOffset, baseVertex);
        }
        boolean nonEmpty = false;
        for (MultiDrawBatch batch : this.batches) {
            batch.end();
            nonEmpty |= !batch.isEmpty();
        }
        return nonEmpty;
    }

    private GlTessellation createTessellationForRegion(CommandList commandList, RenderRegion.RenderRegionArenas arenas) {
        GlTessellation tessellation = arenas.getTessellation();
        if (tessellation == null) {
            tessellation = this.createRegionTessellation(commandList, arenas);
            arenas.setTessellation(tessellation);
        }
        return tessellation;
    }

    private void executeDrawBatches(CommandList commandList, GlTessellation tessellation) {
        for (int i = 0; i < this.batches.length; ++i) {
            MultiDrawBatch batch = this.batches[i];
            try (DrawCommandList drawCommandList = commandList.beginTessellating(tessellation);){
                drawCommandList.multiDrawElementsBaseVertex(batch.getPointerBuffer(), batch.getCountBuffer(), batch.getBaseVertexBuffer(), GlIndexType.VALUES[i]);
                continue;
            }
        }
    }

    private void pushCameraTranslation(RenderRegion region, ChunkCameraContext camera) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer fb = stack.mallocFloat(3);
            fb.put(0, RegionChunkRenderer.getCameraTranslation(region.getOriginX(), camera.blockX, camera.deltaX));
            fb.put(1, RegionChunkRenderer.getCameraTranslation(region.getOriginY(), camera.blockY, camera.deltaY));
            fb.put(2, RegionChunkRenderer.getCameraTranslation(region.getOriginZ(), camera.blockZ, camera.deltaZ));
            GL20C.glUniform3fv((int)this.activeProgram.uCameraTranslation, (FloatBuffer)fb);
        }
    }

    private void addDrawCall(ElementRange part, long baseIndexPointer, int baseVertexIndex) {
        if (part != null) {
            MultiDrawBatch batch = this.batches[part.indexType().ordinal()];
            batch.add(baseIndexPointer + (long)part.elementPointer(), part.elementCount(), baseVertexIndex + part.baseVertex());
        }
    }

    private GlTessellation createRegionTessellation(CommandList commandList, RenderRegion.RenderRegionArenas arenas) {
        return commandList.createTessellation(GlPrimitiveType.TRIANGLES, new TessellationBinding[]{new TessellationBinding(arenas.vertexBuffers.getBufferObject(), this.vertexAttributeBindings)}, arenas.indexBuffers.getBufferObject());
    }

    @Override
    public void delete() {
        super.delete();
        for (MultiDrawBatch batch : this.batches) {
            batch.delete();
        }
        RenderDevice.INSTANCE.createCommandList().deleteBuffer(this.chunkInfoBuffer);
    }

    private static Iterable<Map.Entry<RenderRegion, List<RenderSection>>> sortedRegions(ChunkRenderList list, boolean translucent) {
        return list.sorted(translucent);
    }

    private static Iterable<RenderSection> sortedChunks(List<RenderSection> chunks, boolean translucent) {
        return translucent ? Lists.reverse(chunks) : chunks;
    }

    private static float getCameraTranslation(int chunkBlockPos, int cameraBlockPos, float cameraPos) {
        return (float)(chunkBlockPos - cameraBlockPos) - cameraPos;
    }
}

