/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkAdjacencyMap;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkCameraContext;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkUpdateType;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.graph.ChunkGraphInfo;
import me.jellysquid.mods.sodium.client.render.chunk.graph.ChunkGraphIterationQueue;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPassManager;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegionManager;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegionVisibility;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderEmptyBuildTask;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderRebuildTask;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import me.jellysquid.mods.sodium.client.world.ChunkStatusListener;
import me.jellysquid.mods.sodium.client.world.ClientChunkManagerExtended;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import me.jellysquid.mods.sodium.common.util.collections.FutureQueueDrainingIterator;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;

public class RenderSectionManager
implements ChunkStatusListener {
    private static final double NEARBY_CHUNK_DISTANCE = Math.pow(48.0, 2.0);
    private static final float FOG_PLANE_MIN_DISTANCE = (float)Math.pow(8.0, 2.0);
    private static final float FOG_PLANE_OFFSET = 12.0f;
    private final ChunkBuilder builder;
    private final ChunkRenderer chunkRenderer;
    private final RenderRegionManager regions;
    private final ClonedChunkSectionCache sectionCache;
    private final Long2ReferenceMap<RenderSection> sections = new Long2ReferenceOpenHashMap();
    private final Map<ChunkUpdateType, PriorityQueue<RenderSection>> rebuildQueues = new EnumMap<ChunkUpdateType, PriorityQueue<RenderSection>>(ChunkUpdateType.class);
    private final ChunkAdjacencyMap adjacencyMap = new ChunkAdjacencyMap();
    private final ChunkRenderList chunkRenderList = new ChunkRenderList();
    private final ChunkGraphIterationQueue iterationQueue = new ChunkGraphIterationQueue();
    private final ObjectList<RenderSection> tickableChunks = new ObjectArrayList();
    private final ObjectList<class_2586> visibleBlockEntities = new ObjectArrayList();
    private final SodiumWorldRenderer worldRenderer;
    private final class_638 world;
    private final int renderDistance;
    private float cameraX;
    private float cameraY;
    private float cameraZ;
    private int centerChunkX;
    private int centerChunkZ;
    private boolean needsUpdate;
    private boolean useFogCulling;
    private boolean useOcclusionCulling;
    private double fogRenderCutoff;
    private FrustumExtended frustum;
    private int currentFrame = 0;

    public RenderSectionManager(SodiumWorldRenderer worldRenderer, ChunkRenderer chunkRenderer, BlockRenderPassManager renderPassManager, class_638 world, int renderDistance) {
        this.chunkRenderer = chunkRenderer;
        this.worldRenderer = worldRenderer;
        this.world = world;
        this.builder = new ChunkBuilder(chunkRenderer.getVertexType());
        this.builder.init(world, renderPassManager);
        this.needsUpdate = true;
        this.renderDistance = renderDistance;
        this.regions = new RenderRegionManager(this.chunkRenderer);
        this.sectionCache = new ClonedChunkSectionCache((class_1937)this.world);
        for (ChunkUpdateType type : ChunkUpdateType.values()) {
            this.rebuildQueues.put(type, (PriorityQueue<RenderSection>)new ObjectArrayFIFOQueue());
        }
    }

    public void loadChunks() {
        LongIterator it = ((ClientChunkManagerExtended)this.world.method_2935()).getLoadedChunks().iterator();
        while (it.hasNext()) {
            long pos = it.nextLong();
            this.onChunkAdded(class_1923.method_8325((long)pos), class_1923.method_8332((long)pos));
        }
    }

    public void update(class_4184 camera, FrustumExtended frustum, int frame, boolean spectator) {
        this.resetLists();
        this.regions.updateVisibility(frustum);
        this.setup(camera);
        this.iterateChunks(camera, frustum, frame, spectator);
        this.needsUpdate = false;
    }

    private void setup(class_4184 camera) {
        float dist;
        class_243 cameraPos = camera.method_19326();
        this.cameraX = (float)cameraPos.field_1352;
        this.cameraY = (float)cameraPos.field_1351;
        this.cameraZ = (float)cameraPos.field_1350;
        this.useFogCulling = false;
        if (SodiumClientMod.options().advanced.useFogOcclusion && (dist = RenderSystem.getShaderFogEnd() + 12.0f) != 0.0f) {
            this.useFogCulling = true;
            this.fogRenderCutoff = Math.max(FOG_PLANE_MIN_DISTANCE, dist * dist);
        }
    }

    private void iterateChunks(class_4184 camera, FrustumExtended frustum, int frame, boolean spectator) {
        this.initSearch(camera, frustum, frame, spectator);
        ChunkGraphIterationQueue queue = this.iterationQueue;
        for (int i = 0; i < queue.size(); ++i) {
            RenderSection section = queue.getRender(i);
            class_2350 flow = queue.getDirection(i);
            this.schedulePendingUpdates(section);
            for (class_2350 dir : DirectionUtil.ALL_DIRECTIONS) {
                RenderSection adj;
                if (this.isCulled(section.getGraphInfo(), flow, dir) || (adj = section.getAdjacent(dir)) == null || !this.isWithinRenderDistance(adj)) continue;
                this.bfsEnqueue(section, adj, DirectionUtil.getOpposite(dir));
            }
        }
    }

    private void schedulePendingUpdates(RenderSection section) {
        if (section.getPendingUpdate() == null || !this.adjacencyMap.hasNeighbors(section.getChunkX(), section.getChunkZ())) {
            return;
        }
        PriorityQueue<RenderSection> queue = this.rebuildQueues.get((Object)section.getPendingUpdate());
        if (queue.size() >= 32) {
            return;
        }
        queue.enqueue((Object)section);
    }

    private void addChunkToVisible(RenderSection render) {
        this.chunkRenderList.add(render);
        if (render.isTickable()) {
            this.tickableChunks.add((Object)render);
        }
    }

    private void addEntitiesToRenderLists(RenderSection render) {
        Collection<class_2586> blockEntities = render.getData().getBlockEntities();
        if (!blockEntities.isEmpty()) {
            this.visibleBlockEntities.addAll(blockEntities);
        }
    }

    private void resetLists() {
        for (PriorityQueue<RenderSection> queue : this.rebuildQueues.values()) {
            queue.clear();
        }
        this.visibleBlockEntities.clear();
        this.chunkRenderList.clear();
        this.tickableChunks.clear();
    }

    public Collection<class_2586> getVisibleBlockEntities() {
        return this.visibleBlockEntities;
    }

    @Override
    public void onChunkAdded(int x, int z) {
        this.adjacencyMap.onChunkLoaded(x, z);
        for (int y = this.world.method_32891(); y < this.world.method_31597(); ++y) {
            this.needsUpdate |= this.loadSection(x, y, z);
        }
    }

    @Override
    public void onChunkRemoved(int x, int z) {
        this.adjacencyMap.onChunkUnloaded(x, z);
        for (int y = this.world.method_32891(); y < this.world.method_31597(); ++y) {
            this.needsUpdate |= this.unloadSection(x, y, z);
        }
    }

    private boolean loadSection(int x, int y, int z) {
        RenderRegion region = this.regions.createRegionForChunk(x, y, z);
        RenderSection render = new RenderSection(this.worldRenderer, x, y, z, region);
        region.addChunk(render);
        this.sections.put(class_4076.method_18685((int)x, (int)y, (int)z), (Object)render);
        class_2818 chunk = this.world.method_8497(x, z);
        class_2826 section = chunk.method_12006()[this.world.method_31603(y)];
        if (class_2826.method_18090((class_2826)section)) {
            render.setData(ChunkRenderData.EMPTY);
        } else {
            render.markForUpdate(ChunkUpdateType.INITIAL_BUILD);
        }
        this.connectNeighborNodes(render);
        return true;
    }

    private boolean unloadSection(int x, int y, int z) {
        RenderSection chunk = (RenderSection)this.sections.remove(class_4076.method_18685((int)x, (int)y, (int)z));
        if (chunk == null) {
            throw new IllegalStateException("Chunk is not loaded: " + class_4076.method_18685((int)x, (int)y, (int)z));
        }
        chunk.delete();
        this.disconnectNeighborNodes(chunk);
        RenderRegion region = chunk.getRegion();
        region.removeChunk(chunk);
        return true;
    }

    public void renderLayer(class_4587 matrixStack, BlockRenderPass pass, double x, double y, double z) {
        RenderDevice device = RenderDevice.INSTANCE;
        CommandList commandList = device.createCommandList();
        this.chunkRenderer.render(matrixStack, commandList, this.chunkRenderList, pass, new ChunkCameraContext(x, y, z));
        commandList.flush();
    }

    public void tickVisibleRenders() {
        for (RenderSection render : this.tickableChunks) {
            render.tick();
        }
    }

    public boolean isSectionVisible(int x, int y, int z) {
        RenderSection render = this.getRenderSection(x, y, z);
        if (render == null) {
            return false;
        }
        return render.getGraphInfo().getLastVisibleFrame() == this.currentFrame;
    }

    public void updateChunks() {
        PriorityQueue<CompletableFuture<ChunkBuildResult>> blockingFutures = this.submitRebuildTasks(ChunkUpdateType.IMPORTANT_REBUILD);
        this.submitRebuildTasks(ChunkUpdateType.INITIAL_BUILD);
        this.submitRebuildTasks(ChunkUpdateType.REBUILD);
        this.needsUpdate |= this.performPendingUploads();
        if (!blockingFutures.isEmpty()) {
            this.needsUpdate = true;
            this.regions.upload(RenderDevice.INSTANCE.createCommandList(), new FutureQueueDrainingIterator<ChunkBuildResult>(blockingFutures));
        }
        this.regions.cleanup();
    }

    private PriorityQueue<CompletableFuture<ChunkBuildResult>> submitRebuildTasks(ChunkUpdateType filterType) {
        int budget = filterType.isImportant() ? Integer.MAX_VALUE : this.builder.getSchedulingBudget();
        ObjectArrayFIFOQueue immediateFutures = new ObjectArrayFIFOQueue();
        PriorityQueue<RenderSection> queue = this.rebuildQueues.get((Object)filterType);
        while (budget > 0 && !queue.isEmpty()) {
            CompletableFuture<Object> future;
            RenderSection section = (RenderSection)queue.dequeue();
            if (section.isDisposed()) continue;
            if (section.getPendingUpdate() != filterType) {
                SodiumClientMod.logger().warn("{} changed update type to {} while in queue for {}, skipping", (Object)section, (Object)section.getPendingUpdate(), (Object)filterType);
                continue;
            }
            ChunkRenderBuildTask task = this.createRebuildTask(section);
            if (filterType.isImportant()) {
                CompletableFuture<ChunkBuildResult> immediateFuture = this.builder.schedule(task);
                immediateFutures.enqueue(immediateFuture);
                future = immediateFuture;
            } else {
                future = this.builder.scheduleDeferred(task);
            }
            section.onBuildSubmitted(future);
            --budget;
        }
        return immediateFutures;
    }

    private boolean performPendingUploads() {
        Iterator<ChunkBuildResult> it = this.builder.createDeferredBuildResultDrain();
        if (!it.hasNext()) {
            return false;
        }
        this.regions.upload(RenderDevice.INSTANCE.createCommandList(), it);
        return true;
    }

    public ChunkRenderBuildTask createRebuildTask(RenderSection render) {
        ChunkRenderContext context = WorldSlice.prepare((class_1937)this.world, render.getChunkPos(), this.sectionCache);
        int frame = this.currentFrame;
        if (context == null) {
            return new ChunkRenderEmptyBuildTask(render, frame);
        }
        return new ChunkRenderRebuildTask(render, context, frame);
    }

    public void markGraphDirty() {
        this.needsUpdate = true;
    }

    public boolean isGraphDirty() {
        return this.needsUpdate;
    }

    public ChunkBuilder getBuilder() {
        return this.builder;
    }

    public void destroy() {
        this.resetLists();
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.regions.delete(commandList);
        }
        this.builder.stopWorkers();
    }

    public int getTotalSections() {
        int sum = 0;
        for (RenderRegion region : this.regions.getLoadedRegions()) {
            sum += region.getChunkCount();
        }
        return sum;
    }

    public int getVisibleChunkCount() {
        return this.chunkRenderList.getCount();
    }

    public void scheduleRebuild(int x, int y, int z, boolean important) {
        this.sectionCache.invalidate(x, y, z);
        RenderSection section = (RenderSection)this.sections.get(class_4076.method_18685((int)x, (int)y, (int)z));
        if (section != null && section.isBuilt()) {
            if (important || this.isChunkPrioritized(section)) {
                section.markForUpdate(ChunkUpdateType.IMPORTANT_REBUILD);
            } else {
                section.markForUpdate(ChunkUpdateType.REBUILD);
            }
        }
        this.needsUpdate = true;
    }

    public boolean isChunkPrioritized(RenderSection render) {
        return render.getSquaredDistance(this.cameraX, this.cameraY, this.cameraZ) <= NEARBY_CHUNK_DISTANCE;
    }

    public void onChunkRenderUpdates(int x, int y, int z, ChunkRenderData data) {
        RenderSection node = this.getRenderSection(x, y, z);
        if (node != null) {
            node.setOcclusionData(data.getOcclusionData());
        }
    }

    private boolean isWithinRenderDistance(RenderSection adj) {
        int x = Math.abs(adj.getChunkX() - this.centerChunkX);
        int z = Math.abs(adj.getChunkZ() - this.centerChunkZ);
        return x <= this.renderDistance && z <= this.renderDistance;
    }

    private boolean isCulled(ChunkGraphInfo node, class_2350 from, class_2350 to) {
        if (node.canCull(to)) {
            return true;
        }
        return this.useOcclusionCulling && from != null && !node.isVisibleThrough(from, to);
    }

    private void initSearch(class_4184 camera, FrustumExtended frustum, int frame, boolean spectator) {
        this.currentFrame = frame;
        this.frustum = frustum;
        this.useOcclusionCulling = class_310.method_1551().field_1730;
        this.iterationQueue.clear();
        class_2338 origin = camera.method_19328();
        int chunkX = origin.method_10263() >> 4;
        int chunkY = origin.method_10264() >> 4;
        int chunkZ = origin.method_10260() >> 4;
        this.centerChunkX = chunkX;
        this.centerChunkZ = chunkZ;
        RenderSection rootRender = this.getRenderSection(chunkX, chunkY, chunkZ);
        if (rootRender != null) {
            ChunkGraphInfo rootInfo = rootRender.getGraphInfo();
            rootInfo.resetCullingState();
            rootInfo.setLastVisibleFrame(frame);
            if (spectator && this.world.method_8320(origin).method_26216((class_1922)this.world, origin)) {
                this.useOcclusionCulling = false;
            }
            this.addVisible(rootRender, null);
        } else {
            chunkY = class_3532.method_15340((int)(origin.method_10264() >> 4), (int)this.world.method_32891(), (int)(this.world.method_31597() - 1));
            ArrayList<RenderSection> sorted = new ArrayList<RenderSection>();
            for (int x2 = -this.renderDistance; x2 <= this.renderDistance; ++x2) {
                for (int z2 = -this.renderDistance; z2 <= this.renderDistance; ++z2) {
                    ChunkGraphInfo info;
                    RenderSection render = this.getRenderSection(chunkX + x2, chunkY, chunkZ + z2);
                    if (render == null || (info = render.getGraphInfo()).isCulledByFrustum(frustum)) continue;
                    info.resetCullingState();
                    info.setLastVisibleFrame(frame);
                    sorted.add(render);
                }
            }
            sorted.sort(Comparator.comparingDouble(node -> node.getSquaredDistance(origin)));
            for (RenderSection render : sorted) {
                this.addVisible(render, null);
            }
        }
    }

    private void bfsEnqueue(RenderSection parent, RenderSection render, class_2350 flow) {
        ChunkGraphInfo info = render.getGraphInfo();
        if (info.getLastVisibleFrame() == this.currentFrame) {
            return;
        }
        RenderRegionVisibility parentVisibility = parent.getRegion().getVisibility();
        if (parentVisibility == RenderRegionVisibility.CULLED) {
            return;
        }
        if (parentVisibility == RenderRegionVisibility.VISIBLE && info.isCulledByFrustum(this.frustum)) {
            return;
        }
        info.setLastVisibleFrame(this.currentFrame);
        info.setCullingState(parent.getGraphInfo().getCullingState(), flow);
        this.addVisible(render, flow);
    }

    private void addVisible(RenderSection render, class_2350 flow) {
        this.iterationQueue.add(render, flow);
        if (this.useFogCulling && render.getSquaredDistanceXZ(this.cameraX, this.cameraZ) >= this.fogRenderCutoff) {
            return;
        }
        if (!render.isEmpty()) {
            this.addChunkToVisible(render);
            this.addEntitiesToRenderLists(render);
        }
    }

    private void connectNeighborNodes(RenderSection render) {
        for (class_2350 dir : DirectionUtil.ALL_DIRECTIONS) {
            RenderSection adj = this.getRenderSection(render.getChunkX() + dir.method_10148(), render.getChunkY() + dir.method_10164(), render.getChunkZ() + dir.method_10165());
            if (adj == null) continue;
            adj.setAdjacentNode(DirectionUtil.getOpposite(dir), render);
            render.setAdjacentNode(dir, adj);
        }
    }

    private void disconnectNeighborNodes(RenderSection render) {
        for (class_2350 dir : DirectionUtil.ALL_DIRECTIONS) {
            RenderSection adj = render.getAdjacent(dir);
            if (adj == null) continue;
            adj.setAdjacentNode(DirectionUtil.getOpposite(dir), null);
            render.setAdjacentNode(dir, null);
        }
    }

    private RenderSection getRenderSection(int x, int y, int z) {
        return (RenderSection)this.sections.get(class_4076.method_18685((int)x, (int)y, (int)z));
    }

    public Collection<RenderRegion> getRegions() {
        return this.regions.getLoadedRegions();
    }
}

