/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.region;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferArena;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.tessellation.GlTessellation;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegionVisibility;
import me.jellysquid.mods.sodium.client.util.MathUtil;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;
import net.minecraft.class_4076;
import org.apache.commons.lang3.Validate;

public class RenderRegion {
    public static final int REGION_WIDTH = 8;
    public static final int REGION_HEIGHT = 4;
    public static final int REGION_LENGTH = 8;
    private static final int REGION_WIDTH_M = 7;
    private static final int REGION_HEIGHT_M = 3;
    private static final int REGION_LENGTH_M = 7;
    private static final int REGION_WIDTH_SH = Integer.bitCount(7);
    private static final int REGION_HEIGHT_SH = Integer.bitCount(3);
    private static final int REGION_LENGTH_SH = Integer.bitCount(7);
    public static final int REGION_SIZE = 256;
    private final ChunkRenderer renderer;
    private final Set<RenderSection> chunks = new ObjectOpenHashSet();
    private final Map<BlockRenderPass, RenderRegionArenas> arenas = new EnumMap<BlockRenderPass, RenderRegionArenas>(BlockRenderPass.class);
    private final int x;
    private final int y;
    private final int z;
    private RenderRegionVisibility visibility;

    public RenderRegion(ChunkRenderer renderer, int x, int y, int z) {
        this.renderer = renderer;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static RenderRegion createRegionForChunk(ChunkRenderer renderer, int x, int y, int z) {
        return new RenderRegion(renderer, x >> REGION_WIDTH_SH, y >> REGION_HEIGHT_SH, z >> REGION_LENGTH_SH);
    }

    public RenderRegionArenas getArenas(BlockRenderPass pass) {
        return this.arenas.get((Object)pass);
    }

    public void deleteResources(CommandList commandList) {
        for (RenderRegionArenas arenas : this.arenas.values()) {
            arenas.delete(commandList);
        }
        this.arenas.clear();
    }

    public static long getRegionKeyForChunk(int x, int y, int z) {
        return class_4076.method_18685((int)(x >> REGION_WIDTH_SH), (int)(y >> REGION_HEIGHT_SH), (int)(z >> REGION_LENGTH_SH));
    }

    public int getOriginX() {
        return this.x << REGION_WIDTH_SH << 4;
    }

    public int getOriginY() {
        return this.y << REGION_HEIGHT_SH << 4;
    }

    public int getOriginZ() {
        return this.z << REGION_LENGTH_SH << 4;
    }

    public RenderRegionArenas getOrCreateArenas(CommandList commandList, BlockRenderPass pass) {
        RenderRegionArenas arenas = this.arenas.get((Object)pass);
        if (arenas == null) {
            arenas = new RenderRegionArenas(commandList, this.renderer);
            this.arenas.put(pass, arenas);
        }
        return arenas;
    }

    public void addChunk(RenderSection chunk) {
        if (!this.chunks.add(chunk)) {
            throw new IllegalStateException("Chunk " + chunk + " is already a member of region " + this);
        }
    }

    public void removeChunk(RenderSection chunk) {
        if (!this.chunks.remove(chunk)) {
            throw new IllegalStateException("Chunk " + chunk + " is not a member of region " + this);
        }
    }

    public boolean isEmpty() {
        return this.chunks.isEmpty();
    }

    public int getChunkCount() {
        return this.chunks.size();
    }

    public void updateVisibility(FrustumExtended frustum) {
        int x = this.getOriginX();
        int y = this.getOriginY();
        int z = this.getOriginZ();
        this.visibility = frustum.aabbTest(x, y, z, x + 128, y + 64, z + 128);
    }

    public RenderRegionVisibility getVisibility() {
        return this.visibility;
    }

    public static int getChunkIndex(int x, int y, int z) {
        return x * 8 * 4 + y * 8 + z;
    }

    static {
        Validate.isTrue((boolean)MathUtil.isPowerOfTwo(8));
        Validate.isTrue((boolean)MathUtil.isPowerOfTwo(4));
        Validate.isTrue((boolean)MathUtil.isPowerOfTwo(8));
    }

    public static class RenderRegionArenas {
        public final GlBufferArena vertexBuffers;
        public final GlBufferArena indexBuffers;
        public GlTessellation tessellation;

        public RenderRegionArenas(CommandList commandList, ChunkRenderer renderer) {
            int expectedVertexCount = 32768;
            int expectedIndexCount = expectedVertexCount / 4 * 6;
            this.vertexBuffers = GlBufferArena.createVertexArena(commandList, expectedVertexCount, renderer.getVertexType().getBufferVertexFormat().getStride());
            this.indexBuffers = GlBufferArena.createIndexArena(commandList, expectedIndexCount);
        }

        public void delete(CommandList commandList) {
            this.vertexBuffers.delete(commandList);
            this.indexBuffers.delete(commandList);
            if (this.tessellation != null) {
                commandList.deleteTessellation(this.tessellation);
            }
        }

        public void setTessellation(GlTessellation tessellation) {
            this.tessellation = tessellation;
        }

        public GlTessellation getTessellation() {
            return this.tessellation;
        }

        public boolean isEmpty() {
            return this.vertexBuffers.isEmpty() && this.indexBuffers.isEmpty();
        }

        public long getUsedMemory() {
            return this.vertexBuffers.getUsedMemory() + this.indexBuffers.getUsedMemory();
        }

        public long getAllocatedMemory() {
            return this.vertexBuffers.getAllocatedMemory() + this.indexBuffers.getAllocatedMemory();
        }

        public void invalidateTessellation(CommandList commandList) {
            if (this.tessellation != null) {
                commandList.deleteTessellation(this.tessellation);
                this.tessellation = null;
            }
        }
    }
}

