/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.region;

import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.jellysquid.mods.sodium.client.gl.arena.PendingUpload;
import me.jellysquid.mods.sodium.client.gl.buffer.IndexedVertexData;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import me.jellysquid.mods.sodium.client.util.math.FrustumExtended;

public class RenderRegionManager {
    private final Long2ReferenceOpenHashMap<RenderRegion> regions = new Long2ReferenceOpenHashMap();
    private final ChunkRenderer renderer;

    public RenderRegionManager(ChunkRenderer renderer) {
        this.renderer = renderer;
    }

    public void updateVisibility(FrustumExtended frustum) {
        for (RenderRegion region : this.regions.values()) {
            if (region.isEmpty()) continue;
            region.updateVisibility(frustum);
        }
    }

    public void cleanup() {
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.cleanup(commandList);
        }
    }

    public void cleanup(CommandList commandList) {
        ObjectIterator it = this.regions.values().iterator();
        while (it.hasNext()) {
            RenderRegion region = (RenderRegion)it.next();
            if (!region.isEmpty()) continue;
            region.deleteResources(commandList);
            it.remove();
        }
    }

    public void upload(CommandList commandList, Iterator<ChunkBuildResult> queue) {
        for (Map.Entry<RenderRegion, List<ChunkBuildResult>> entry : this.setupUploadBatches(queue).entrySet()) {
            RenderRegion region = entry.getKey();
            List<ChunkBuildResult> uploadQueue = entry.getValue();
            for (BlockRenderPass pass : BlockRenderPass.VALUES) {
                this.upload(commandList, region, pass, uploadQueue);
            }
            for (ChunkBuildResult result : uploadQueue) {
                result.render.onBuildFinished(result);
                result.delete();
            }
        }
    }

    private void upload(CommandList commandList, RenderRegion region, BlockRenderPass pass, List<ChunkBuildResult> results) {
        ArrayList<PendingSectionUpload> sectionUploads = new ArrayList<PendingSectionUpload>();
        for (ChunkBuildResult result : results) {
            ChunkMeshData meshData;
            ChunkGraphicsState graphics = result.render.setGraphicsState(pass, null);
            if (graphics != null) {
                graphics.delete();
            }
            if ((meshData = result.getMesh(pass)) == null) continue;
            IndexedVertexData vertexData = meshData.getVertexData();
            sectionUploads.add(new PendingSectionUpload(result.render, meshData, new PendingUpload(vertexData.vertexBuffer()), new PendingUpload(vertexData.indexBuffer())));
        }
        if (sectionUploads.isEmpty()) {
            return;
        }
        RenderRegion.RenderRegionArenas arenas = region.getOrCreateArenas(commandList, pass);
        boolean bufferChanged = arenas.vertexBuffers.upload(commandList, sectionUploads.stream().map(i -> i.vertexUpload));
        if (bufferChanged |= arenas.indexBuffers.upload(commandList, sectionUploads.stream().map(i -> i.indicesUpload))) {
            arenas.invalidateTessellation(commandList);
        }
        for (PendingSectionUpload upload : sectionUploads) {
            upload.section.setGraphicsState(pass, new ChunkGraphicsState(upload.vertexUpload.getResult(), upload.indicesUpload.getResult(), upload.meshData));
        }
    }

    private Map<RenderRegion, List<ChunkBuildResult>> setupUploadBatches(Iterator<ChunkBuildResult> renders) {
        Reference2ObjectLinkedOpenHashMap map = new Reference2ObjectLinkedOpenHashMap();
        while (renders.hasNext()) {
            ChunkBuildResult result;
            RenderSection render = result.render;
            result = renders.next();
            if (!render.canAcceptBuildResults(result)) {
                result.delete();
                continue;
            }
            RenderRegion region = (RenderRegion)this.regions.get(RenderRegion.getRegionKeyForChunk(render.getChunkX(), render.getChunkY(), render.getChunkZ()));
            if (region == null) {
                throw new NullPointerException("Couldn't find region for chunk: " + render);
            }
            List uploadQueue = map.computeIfAbsent(region, k -> new ArrayList());
            uploadQueue.add(result);
        }
        return map;
    }

    public RenderRegion createRegionForChunk(int x, int y, int z) {
        long key = RenderRegion.getRegionKeyForChunk(x, y, z);
        RenderRegion region = (RenderRegion)this.regions.get(key);
        if (region == null) {
            region = RenderRegion.createRegionForChunk(this.renderer, x, y, z);
            this.regions.put(key, (Object)region);
        }
        return region;
    }

    public void delete(CommandList commandList) {
        for (RenderRegion region : this.regions.values()) {
            region.deleteResources(commandList);
        }
        this.regions.clear();
    }

    public Collection<RenderRegion> getLoadedRegions() {
        return this.regions.values();
    }

    private static class PendingSectionUpload {
        private final RenderSection section;
        private final ChunkMeshData meshData;
        private final PendingUpload vertexUpload;
        private final PendingUpload indicesUpload;

        private PendingSectionUpload(RenderSection section, ChunkMeshData meshData, PendingUpload vertexUpload, PendingUpload indicesUpload) {
            this.section = section;
            this.meshData = meshData;
            this.vertexUpload = vertexUpload;
            this.indicesUpload = indicesUpload;
        }
    }
}

