/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.shader;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderFogComponent;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderOptions;
import net.minecraft.class_1159;
import net.minecraft.class_4587;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.system.MemoryStack;

public class ChunkProgram
extends GlProgram {
    private final int uModelViewProjectionMatrix = this.getUniformLocation("u_ModelViewProjectionMatrix");
    private final int uModelScale;
    private final int uModelOffset;
    private final int uTextureScale;
    private final int uBlockTex = this.getUniformLocation("u_BlockTex");
    private final int uLightTex = this.getUniformLocation("u_LightTex");
    public final int uCameraTranslation;
    public final int uboDrawParametersIndex;
    private final ChunkShaderFogComponent fogShader;

    public ChunkProgram(RenderDevice owner, int handle, ChunkShaderOptions options) {
        super(handle);
        this.uModelScale = this.getUniformLocation("u_ModelScale");
        this.uModelOffset = this.getUniformLocation("u_ModelOffset");
        this.uTextureScale = this.getUniformLocation("u_TextureScale");
        this.uCameraTranslation = this.getUniformLocation("u_CameraTranslation");
        this.uboDrawParametersIndex = this.getUniformBlockIndex("ubo_DrawParameters");
        this.fogShader = options.fog().getFactory().apply(this);
    }

    public void setup(class_4587 matrixStack, ChunkVertexType vertexType) {
        RenderSystem.activeTexture((int)33984);
        RenderSystem.bindTexture((int)RenderSystem.getShaderTexture((int)0));
        RenderSystem.activeTexture((int)33986);
        RenderSystem.bindTexture((int)RenderSystem.getShaderTexture((int)2));
        GL20C.glUniform1i((int)this.uBlockTex, (int)0);
        GL20C.glUniform1i((int)this.uLightTex, (int)2);
        GL20C.glUniform1f((int)this.uModelScale, (float)vertexType.getModelScale());
        GL20C.glUniform1f((int)this.uModelOffset, (float)vertexType.getModelOffset());
        GL20C.glUniform1f((int)this.uTextureScale, (float)vertexType.getTextureScale());
        this.fogShader.setup();
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            FloatBuffer bufModelViewProjection = memoryStack.mallocFloat(16);
            class_1159 matrix = RenderSystem.getProjectionMatrix().method_22673();
            matrix.method_22672(matrixStack.method_23760().method_23761());
            matrix.method_4932(bufModelViewProjection);
            GL20C.glUniformMatrix4fv((int)this.uModelViewProjectionMatrix, (boolean)false, (FloatBuffer)bufModelViewProjection);
        }
    }
}

