/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.occlusion;

import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;

public class BlockOcclusionCache {
    private static final byte UNCACHED_VALUE = 127;
    private final Object2ByteLinkedOpenHashMap<CachedOcclusionShapeTest> map;
    private final CachedOcclusionShapeTest cachedTest = new CachedOcclusionShapeTest();
    private final class_2338.class_2339 cpos = new class_2338.class_2339();

    public BlockOcclusionCache() {
        this.map = new Object2ByteLinkedOpenHashMap(2048, 0.5f);
        this.map.defaultReturnValue((byte)127);
    }

    public boolean shouldDrawSide(class_2680 selfState, class_1922 view, class_2338 pos, class_2350 facing) {
        class_2338.class_2339 adjPos = this.cpos;
        adjPos.method_10103(pos.method_10263() + facing.method_10148(), pos.method_10264() + facing.method_10164(), pos.method_10260() + facing.method_10165());
        class_2680 adjState = view.method_8320((class_2338)adjPos);
        if (selfState.method_26187(adjState, facing)) {
            return false;
        }
        if (adjState.method_26225()) {
            class_265 selfShape = selfState.method_26173(view, pos, facing);
            class_265 adjShape = adjState.method_26173(view, (class_2338)adjPos, facing.method_10153());
            if (selfShape == class_259.method_1077() && adjShape == class_259.method_1077()) {
                return false;
            }
            if (selfShape.method_1110()) {
                return true;
            }
            return this.calculate(selfShape, adjShape);
        }
        return true;
    }

    private boolean calculate(class_265 selfShape, class_265 adjShape) {
        CachedOcclusionShapeTest cache = this.cachedTest;
        cache.a = selfShape;
        cache.b = adjShape;
        cache.updateHash();
        byte cached = this.map.getByte((Object)cache);
        if (cached != 127) {
            return cached == 1;
        }
        boolean ret = class_259.method_1074((class_265)selfShape, (class_265)adjShape, (class_247)class_247.field_16886);
        this.map.put((Object)cache.copy(), (byte)(ret ? 1 : 0));
        if (this.map.size() > 2048) {
            this.map.removeLastByte();
        }
        return ret;
    }

    private static final class CachedOcclusionShapeTest {
        private class_265 a;
        private class_265 b;
        private int hashCode;

        private CachedOcclusionShapeTest() {
        }

        private CachedOcclusionShapeTest(class_265 a, class_265 b, int hashCode) {
            this.a = a;
            this.b = b;
            this.hashCode = hashCode;
        }

        public void updateHash() {
            int result = System.identityHashCode(this.a);
            this.hashCode = result = 31 * result + System.identityHashCode(this.b);
        }

        public CachedOcclusionShapeTest copy() {
            return new CachedOcclusionShapeTest(this.a, this.b, this.hashCode);
        }

        public boolean equals(Object o) {
            Object object = o;
            if (object instanceof CachedOcclusionShapeTest) {
                CachedOcclusionShapeTest that = (CachedOcclusionShapeTest)object;
                return this.a == that.a && this.b == that.b;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

